package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{ComponentTypeId, TwinMakerArn, Id}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateComponentTypeResponse(
    workspaceId: Id,
    arn: TwinMakerArn,
    componentTypeId: ComponentTypeId,
    state: zio.aws.iottwinmaker.model.State
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeResponse = {
    import UpdateComponentTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeResponse
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .arn(TwinMakerArn.unwrap(arn): java.lang.String)
      .componentTypeId(
        ComponentTypeId.unwrap(componentTypeId): java.lang.String
      )
      .state(state.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.UpdateComponentTypeResponse.ReadOnly =
    zio.aws.iottwinmaker.model.UpdateComponentTypeResponse.wrap(buildAwsValue())
}
object UpdateComponentTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.UpdateComponentTypeResponse =
      zio.aws.iottwinmaker.model.UpdateComponentTypeResponse(
        workspaceId,
        arn,
        componentTypeId,
        state
      )
    def workspaceId: Id
    def arn: TwinMakerArn
    def componentTypeId: ComponentTypeId
    def state: zio.aws.iottwinmaker.model.State
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getArn: ZIO[Any, Nothing, TwinMakerArn] = ZIO.succeed(arn)
    def getComponentTypeId: ZIO[Any, Nothing, ComponentTypeId] =
      ZIO.succeed(componentTypeId)
    def getState: ZIO[Any, Nothing, zio.aws.iottwinmaker.model.State] =
      ZIO.succeed(state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeResponse
  ) extends zio.aws.iottwinmaker.model.UpdateComponentTypeResponse.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val arn: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.arn())
    override val componentTypeId: ComponentTypeId =
      zio.aws.iottwinmaker.model.primitives
        .ComponentTypeId(impl.componentTypeId())
    override val state: zio.aws.iottwinmaker.model.State =
      zio.aws.iottwinmaker.model.State.wrap(impl.state())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeResponse
  ): zio.aws.iottwinmaker.model.UpdateComponentTypeResponse.ReadOnly =
    new Wrapper(impl)
}
