package zio.aws.iottwinmaker.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{
  Time,
  NextToken,
  Timestamp,
  EntityId,
  MaxResults,
  ComponentTypeId,
  Name,
  Id
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetPropertyValueHistoryRequest(
    workspaceId: Id,
    entityId: Optional[EntityId] = Optional.Absent,
    componentName: Optional[Name] = Optional.Absent,
    componentTypeId: Optional[ComponentTypeId] = Optional.Absent,
    selectedProperties: Iterable[String],
    propertyFilters: Optional[
      Iterable[zio.aws.iottwinmaker.model.PropertyFilter]
    ] = Optional.Absent,
    startDateTime: Optional[Timestamp] = Optional.Absent,
    endDateTime: Optional[Timestamp] = Optional.Absent,
    interpolation: Optional[
      zio.aws.iottwinmaker.model.InterpolationParameters
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    orderByTime: Optional[zio.aws.iottwinmaker.model.OrderByTime] =
      Optional.Absent,
    startTime: Optional[Time] = Optional.Absent,
    endTime: Optional[Time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest = {
    import GetPropertyValueHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .optionallyWith(
        entityId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.entityId)
      .optionallyWith(
        componentName.map(value => Name.unwrap(value): java.lang.String)
      )(_.componentName)
      .optionallyWith(
        componentTypeId.map(value =>
          ComponentTypeId.unwrap(value): java.lang.String
        )
      )(_.componentTypeId)
      .selectedProperties(selectedProperties.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        propertyFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.propertyFilters)
      .optionallyWith(
        startDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.startDateTime)
      .optionallyWith(
        endDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.endDateTime)
      .optionallyWith(interpolation.map(value => value.buildAwsValue()))(
        _.interpolation
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(orderByTime.map(value => value.unwrap))(_.orderByTime)
      .optionallyWith(
        startTime.map(value => Time.unwrap(value): java.lang.String)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => Time.unwrap(value): java.lang.String)
      )(_.endTime)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.GetPropertyValueHistoryRequest.ReadOnly =
    zio.aws.iottwinmaker.model.GetPropertyValueHistoryRequest
      .wrap(buildAwsValue())
}
object GetPropertyValueHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetPropertyValueHistoryRequest =
      zio.aws.iottwinmaker.model.GetPropertyValueHistoryRequest(
        workspaceId,
        entityId.map(value => value),
        componentName.map(value => value),
        componentTypeId.map(value => value),
        selectedProperties,
        propertyFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        startDateTime.map(value => value),
        endDateTime.map(value => value),
        interpolation.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value),
        orderByTime.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def workspaceId: Id
    def entityId: Optional[EntityId]
    def componentName: Optional[Name]
    def componentTypeId: Optional[ComponentTypeId]
    def selectedProperties: List[String]
    def propertyFilters
        : Optional[List[zio.aws.iottwinmaker.model.PropertyFilter.ReadOnly]]
    def startDateTime: Optional[Timestamp]
    def endDateTime: Optional[Timestamp]
    def interpolation
        : Optional[zio.aws.iottwinmaker.model.InterpolationParameters.ReadOnly]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def orderByTime: Optional[zio.aws.iottwinmaker.model.OrderByTime]
    def startTime: Optional[Time]
    def endTime: Optional[Time]
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getEntityId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("entityId", entityId)
    def getComponentName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("componentName", componentName)
    def getComponentTypeId: ZIO[Any, AwsError, ComponentTypeId] =
      AwsError.unwrapOptionField("componentTypeId", componentTypeId)
    def getSelectedProperties: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(selectedProperties)
    def getPropertyFilters: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.PropertyFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("propertyFilters", propertyFilters)
    def getStartDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startDateTime", startDateTime)
    def getEndDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endDateTime", endDateTime)
    def getInterpolation: ZIO[
      Any,
      AwsError,
      zio.aws.iottwinmaker.model.InterpolationParameters.ReadOnly
    ] = AwsError.unwrapOptionField("interpolation", interpolation)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getOrderByTime
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.OrderByTime] =
      AwsError.unwrapOptionField("orderByTime", orderByTime)
    def getStartTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest
  ) extends zio.aws.iottwinmaker.model.GetPropertyValueHistoryRequest.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val entityId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.entityId())
      .map(value => zio.aws.iottwinmaker.model.primitives.EntityId(value))
    override val componentName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.componentName())
      .map(value => zio.aws.iottwinmaker.model.primitives.Name(value))
    override val componentTypeId: Optional[ComponentTypeId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentTypeId())
        .map(value =>
          zio.aws.iottwinmaker.model.primitives.ComponentTypeId(value)
        )
    override val selectedProperties: List[String] = impl
      .selectedProperties()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val propertyFilters
        : Optional[List[zio.aws.iottwinmaker.model.PropertyFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propertyFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.PropertyFilter.wrap(item)
          }.toList
        )
    override val startDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startDateTime())
      .map(value => zio.aws.iottwinmaker.model.primitives.Timestamp(value))
    override val endDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endDateTime())
      .map(value => zio.aws.iottwinmaker.model.primitives.Timestamp(value))
    override val interpolation: Optional[
      zio.aws.iottwinmaker.model.InterpolationParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.interpolation())
      .map(value =>
        zio.aws.iottwinmaker.model.InterpolationParameters.wrap(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iottwinmaker.model.primitives.MaxResults(value))
    override val orderByTime: Optional[zio.aws.iottwinmaker.model.OrderByTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orderByTime())
        .map(value => zio.aws.iottwinmaker.model.OrderByTime.wrap(value))
    override val startTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.iottwinmaker.model.primitives.Time(value))
    override val endTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.iottwinmaker.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest
  ): zio.aws.iottwinmaker.model.GetPropertyValueHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
