package zio.aws.iottwinmaker.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{
  TwinMakerArn,
  Timestamp,
  SyncSource,
  ParentEntityId,
  Description,
  EntityId,
  Name,
  EntityName,
  Id
}
import scala.jdk.CollectionConverters._
final case class GetEntityResponse(
    entityId: EntityId,
    entityName: EntityName,
    arn: TwinMakerArn,
    status: zio.aws.iottwinmaker.model.Status,
    workspaceId: Id,
    description: Optional[Description] = Optional.Absent,
    components: Optional[
      Map[Name, zio.aws.iottwinmaker.model.ComponentResponse]
    ] = Optional.Absent,
    parentEntityId: ParentEntityId,
    hasChildEntities: Boolean,
    creationDateTime: Timestamp,
    updateDateTime: Timestamp,
    syncSource: Optional[SyncSource] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetEntityResponse = {
    import GetEntityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetEntityResponse
      .builder()
      .entityId(EntityId.unwrap(entityId): java.lang.String)
      .entityName(EntityName.unwrap(entityName): java.lang.String)
      .arn(TwinMakerArn.unwrap(arn): java.lang.String)
      .status(status.buildAwsValue())
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        components.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.components)
      .parentEntityId(ParentEntityId.unwrap(parentEntityId): java.lang.String)
      .hasChildEntities(hasChildEntities: java.lang.Boolean)
      .creationDateTime(Timestamp.unwrap(creationDateTime): Instant)
      .updateDateTime(Timestamp.unwrap(updateDateTime): Instant)
      .optionallyWith(
        syncSource.map(value => SyncSource.unwrap(value): java.lang.String)
      )(_.syncSource)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetEntityResponse.ReadOnly =
    zio.aws.iottwinmaker.model.GetEntityResponse.wrap(buildAwsValue())
}
object GetEntityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetEntityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetEntityResponse =
      zio.aws.iottwinmaker.model.GetEntityResponse(
        entityId,
        entityName,
        arn,
        status.asEditable,
        workspaceId,
        description.map(value => value),
        components.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        parentEntityId,
        hasChildEntities,
        creationDateTime,
        updateDateTime,
        syncSource.map(value => value)
      )
    def entityId: EntityId
    def entityName: EntityName
    def arn: TwinMakerArn
    def status: zio.aws.iottwinmaker.model.Status.ReadOnly
    def workspaceId: Id
    def description: Optional[Description]
    def components: Optional[
      Map[Name, zio.aws.iottwinmaker.model.ComponentResponse.ReadOnly]
    ]
    def parentEntityId: ParentEntityId
    def hasChildEntities: Boolean
    def creationDateTime: Timestamp
    def updateDateTime: Timestamp
    def syncSource: Optional[SyncSource]
    def getEntityId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(entityId)
    def getEntityName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(entityName)
    def getArn: ZIO[Any, Nothing, TwinMakerArn] = ZIO.succeed(arn)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.iottwinmaker.model.Status.ReadOnly] =
      ZIO.succeed(status)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getComponents: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.ComponentResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("components", components)
    def getParentEntityId: ZIO[Any, Nothing, ParentEntityId] =
      ZIO.succeed(parentEntityId)
    def getHasChildEntities: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(hasChildEntities)
    def getCreationDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDateTime)
    def getUpdateDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(updateDateTime)
    def getSyncSource: ZIO[Any, AwsError, SyncSource] =
      AwsError.unwrapOptionField("syncSource", syncSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetEntityResponse
  ) extends zio.aws.iottwinmaker.model.GetEntityResponse.ReadOnly {
    override val entityId: EntityId =
      zio.aws.iottwinmaker.model.primitives.EntityId(impl.entityId())
    override val entityName: EntityName =
      zio.aws.iottwinmaker.model.primitives.EntityName(impl.entityName())
    override val arn: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.arn())
    override val status: zio.aws.iottwinmaker.model.Status.ReadOnly =
      zio.aws.iottwinmaker.model.Status.wrap(impl.status())
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val components: Optional[
      Map[Name, zio.aws.iottwinmaker.model.ComponentResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.components())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.ComponentResponse.wrap(value)
          })
          .toMap
      )
    override val parentEntityId: ParentEntityId =
      zio.aws.iottwinmaker.model.primitives
        .ParentEntityId(impl.parentEntityId())
    override val hasChildEntities: Boolean = impl.hasChildEntities(): Boolean
    override val creationDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.creationDateTime())
    override val updateDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.updateDateTime())
    override val syncSource: Optional[SyncSource] = zio.aws.core.internal
      .optionalFromNullable(impl.syncSource())
      .map(value => zio.aws.iottwinmaker.model.primitives.SyncSource(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetEntityResponse
  ): zio.aws.iottwinmaker.model.GetEntityResponse.ReadOnly = new Wrapper(impl)
}
