package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.BundleName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BundleInformation(
    bundleNames: Iterable[BundleName],
    pricingTier: Optional[zio.aws.iottwinmaker.model.PricingTier] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.BundleInformation = {
    import BundleInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.BundleInformation
      .builder()
      .bundleNames(bundleNames.map { item =>
        BundleName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(pricingTier.map(value => value.unwrap))(_.pricingTier)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.BundleInformation.ReadOnly =
    zio.aws.iottwinmaker.model.BundleInformation.wrap(buildAwsValue())
}
object BundleInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.BundleInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.BundleInformation =
      zio.aws.iottwinmaker.model
        .BundleInformation(bundleNames, pricingTier.map(value => value))
    def bundleNames: List[BundleName]
    def pricingTier: Optional[zio.aws.iottwinmaker.model.PricingTier]
    def getBundleNames: ZIO[Any, Nothing, List[BundleName]] =
      ZIO.succeed(bundleNames)
    def getPricingTier
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.PricingTier] =
      AwsError.unwrapOptionField("pricingTier", pricingTier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.BundleInformation
  ) extends zio.aws.iottwinmaker.model.BundleInformation.ReadOnly {
    override val bundleNames: List[BundleName] = impl
      .bundleNames()
      .asScala
      .map { item =>
        zio.aws.iottwinmaker.model.primitives.BundleName(item)
      }
      .toList
    override val pricingTier: Optional[zio.aws.iottwinmaker.model.PricingTier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pricingTier())
        .map(value => zio.aws.iottwinmaker.model.PricingTier.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.BundleInformation
  ): zio.aws.iottwinmaker.model.BundleInformation.ReadOnly = new Wrapper(impl)
}
