package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetSceneRequest(workspaceId: Id, sceneId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetSceneRequest = {
    import GetSceneRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetSceneRequest
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .sceneId(Id.unwrap(sceneId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetSceneRequest.ReadOnly =
    zio.aws.iottwinmaker.model.GetSceneRequest.wrap(buildAwsValue())
}
object GetSceneRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetSceneRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetSceneRequest =
      zio.aws.iottwinmaker.model.GetSceneRequest(workspaceId, sceneId)
    def workspaceId: Id
    def sceneId: Id
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getSceneId: ZIO[Any, Nothing, Id] = ZIO.succeed(sceneId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetSceneRequest
  ) extends zio.aws.iottwinmaker.model.GetSceneRequest.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val sceneId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.sceneId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetSceneRequest
  ): zio.aws.iottwinmaker.model.GetSceneRequest.ReadOnly = new Wrapper(impl)
}
