package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  ComponentTypeName,
  TagValue,
  Description,
  ComponentTypeId,
  Name,
  Id,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateComponentTypeRequest(
    workspaceId: Id,
    isSingleton: Optional[Boolean] = Optional.Absent,
    componentTypeId: ComponentTypeId,
    description: Optional[Description] = Optional.Absent,
    propertyDefinitions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyDefinitionRequest]
    ] = Optional.Absent,
    extendsFrom: Optional[Iterable[ComponentTypeId]] = Optional.Absent,
    functions: Optional[Map[Name, zio.aws.iottwinmaker.model.FunctionRequest]] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    propertyGroups: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyGroupRequest]
    ] = Optional.Absent,
    componentTypeName: Optional[ComponentTypeName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.CreateComponentTypeRequest = {
    import CreateComponentTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.CreateComponentTypeRequest
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .optionallyWith(isSingleton.map(value => value: java.lang.Boolean))(
        _.isSingleton
      )
      .componentTypeId(
        ComponentTypeId.unwrap(componentTypeId): java.lang.String
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        propertyDefinitions.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.propertyDefinitions)
      .optionallyWith(
        extendsFrom.map(value =>
          value.map { item =>
            ComponentTypeId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.extendsFrom)
      .optionallyWith(
        functions.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.functions)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        propertyGroups.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.propertyGroups)
      .optionallyWith(
        componentTypeName.map(value =>
          ComponentTypeName.unwrap(value): java.lang.String
        )
      )(_.componentTypeName)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.CreateComponentTypeRequest.ReadOnly =
    zio.aws.iottwinmaker.model.CreateComponentTypeRequest.wrap(buildAwsValue())
}
object CreateComponentTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.CreateComponentTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.CreateComponentTypeRequest =
      zio.aws.iottwinmaker.model.CreateComponentTypeRequest(
        workspaceId,
        isSingleton.map(value => value),
        componentTypeId,
        description.map(value => value),
        propertyDefinitions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        extendsFrom.map(value => value),
        functions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        tags.map(value => value),
        propertyGroups.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        componentTypeName.map(value => value)
      )
    def workspaceId: Id
    def isSingleton: Optional[Boolean]
    def componentTypeId: ComponentTypeId
    def description: Optional[Description]
    def propertyDefinitions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyDefinitionRequest.ReadOnly]
    ]
    def extendsFrom: Optional[List[ComponentTypeId]]
    def functions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.FunctionRequest.ReadOnly]
    ]
    def tags: Optional[Map[TagKey, TagValue]]
    def propertyGroups: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyGroupRequest.ReadOnly]
    ]
    def componentTypeName: Optional[ComponentTypeName]
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getIsSingleton: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isSingleton", isSingleton)
    def getComponentTypeId: ZIO[Any, Nothing, ComponentTypeId] =
      ZIO.succeed(componentTypeId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getPropertyDefinitions: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.PropertyDefinitionRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("propertyDefinitions", propertyDefinitions)
    def getExtendsFrom: ZIO[Any, AwsError, List[ComponentTypeId]] =
      AwsError.unwrapOptionField("extendsFrom", extendsFrom)
    def getFunctions: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.FunctionRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("functions", functions)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPropertyGroups: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.PropertyGroupRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("propertyGroups", propertyGroups)
    def getComponentTypeName: ZIO[Any, AwsError, ComponentTypeName] =
      AwsError.unwrapOptionField("componentTypeName", componentTypeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateComponentTypeRequest
  ) extends zio.aws.iottwinmaker.model.CreateComponentTypeRequest.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val isSingleton: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isSingleton())
      .map(value => value: Boolean)
    override val componentTypeId: ComponentTypeId =
      zio.aws.iottwinmaker.model.primitives
        .ComponentTypeId(impl.componentTypeId())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val propertyDefinitions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyDefinitionRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyDefinitions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives
              .Name(key) -> zio.aws.iottwinmaker.model.PropertyDefinitionRequest
              .wrap(value)
          })
          .toMap
      )
    override val extendsFrom: Optional[List[ComponentTypeId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extendsFrom())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.primitives.ComponentTypeId(item)
          }.toList
        )
    override val functions: Optional[
      Map[Name, zio.aws.iottwinmaker.model.FunctionRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.functions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.FunctionRequest.wrap(value)
          })
          .toMap
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.TagKey(
              key
            ) -> zio.aws.iottwinmaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val propertyGroups: Optional[
      Map[Name, zio.aws.iottwinmaker.model.PropertyGroupRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyGroups())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.PropertyGroupRequest.wrap(value)
          })
          .toMap
      )
    override val componentTypeName: Optional[ComponentTypeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentTypeName())
        .map(value =>
          zio.aws.iottwinmaker.model.primitives.ComponentTypeName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateComponentTypeRequest
  ): zio.aws.iottwinmaker.model.CreateComponentTypeRequest.ReadOnly =
    new Wrapper(impl)
}
