package zio.aws.iottwinmaker.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class PricingPlan(
    billableEntityCount: Optional[Long] = Optional.Absent,
    bundleInformation: Optional[zio.aws.iottwinmaker.model.BundleInformation] =
      Optional.Absent,
    effectiveDateTime: Timestamp,
    pricingMode: zio.aws.iottwinmaker.model.PricingMode,
    updateDateTime: Timestamp,
    updateReason: zio.aws.iottwinmaker.model.UpdateReason
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.PricingPlan = {
    import PricingPlan.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.PricingPlan
      .builder()
      .optionallyWith(billableEntityCount.map(value => value: java.lang.Long))(
        _.billableEntityCount
      )
      .optionallyWith(bundleInformation.map(value => value.buildAwsValue()))(
        _.bundleInformation
      )
      .effectiveDateTime(Timestamp.unwrap(effectiveDateTime): Instant)
      .pricingMode(pricingMode.unwrap)
      .updateDateTime(Timestamp.unwrap(updateDateTime): Instant)
      .updateReason(updateReason.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.PricingPlan.ReadOnly =
    zio.aws.iottwinmaker.model.PricingPlan.wrap(buildAwsValue())
}
object PricingPlan {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.PricingPlan
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.PricingPlan =
      zio.aws.iottwinmaker.model.PricingPlan(
        billableEntityCount.map(value => value),
        bundleInformation.map(value => value.asEditable),
        effectiveDateTime,
        pricingMode,
        updateDateTime,
        updateReason
      )
    def billableEntityCount: Optional[Long]
    def bundleInformation
        : Optional[zio.aws.iottwinmaker.model.BundleInformation.ReadOnly]
    def effectiveDateTime: Timestamp
    def pricingMode: zio.aws.iottwinmaker.model.PricingMode
    def updateDateTime: Timestamp
    def updateReason: zio.aws.iottwinmaker.model.UpdateReason
    def getBillableEntityCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("billableEntityCount", billableEntityCount)
    def getBundleInformation: ZIO[
      Any,
      AwsError,
      zio.aws.iottwinmaker.model.BundleInformation.ReadOnly
    ] = AwsError.unwrapOptionField("bundleInformation", bundleInformation)
    def getEffectiveDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(effectiveDateTime)
    def getPricingMode
        : ZIO[Any, Nothing, zio.aws.iottwinmaker.model.PricingMode] =
      ZIO.succeed(pricingMode)
    def getUpdateDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(updateDateTime)
    def getUpdateReason
        : ZIO[Any, Nothing, zio.aws.iottwinmaker.model.UpdateReason] =
      ZIO.succeed(updateReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PricingPlan
  ) extends zio.aws.iottwinmaker.model.PricingPlan.ReadOnly {
    override val billableEntityCount: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.billableEntityCount())
      .map(value => value: Long)
    override val bundleInformation
        : Optional[zio.aws.iottwinmaker.model.BundleInformation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bundleInformation())
        .map(value => zio.aws.iottwinmaker.model.BundleInformation.wrap(value))
    override val effectiveDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.effectiveDateTime())
    override val pricingMode: zio.aws.iottwinmaker.model.PricingMode =
      zio.aws.iottwinmaker.model.PricingMode.wrap(impl.pricingMode())
    override val updateDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.updateDateTime())
    override val updateReason: zio.aws.iottwinmaker.model.UpdateReason =
      zio.aws.iottwinmaker.model.UpdateReason.wrap(impl.updateReason())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PricingPlan
  ): zio.aws.iottwinmaker.model.PricingPlan.ReadOnly = new Wrapper(impl)
}
