package zio.aws.iottwinmaker.model
import scala.jdk.CollectionConverters._
sealed trait UpdateReason {
  def unwrap: software.amazon.awssdk.services.iottwinmaker.model.UpdateReason
}
object UpdateReason {
  def wrap(
      value: software.amazon.awssdk.services.iottwinmaker.model.UpdateReason
  ): zio.aws.iottwinmaker.model.UpdateReason = value match {
    case software.amazon.awssdk.services.iottwinmaker.model.UpdateReason.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iottwinmaker.model.UpdateReason.DEFAULT =>
      val r = DEFAULT
      r
    case software.amazon.awssdk.services.iottwinmaker.model.UpdateReason.PRICING_TIER_UPDATE =>
      val r = PRICING_TIER_UPDATE
      r
    case software.amazon.awssdk.services.iottwinmaker.model.UpdateReason.ENTITY_COUNT_UPDATE =>
      val r = ENTITY_COUNT_UPDATE
      r
    case software.amazon.awssdk.services.iottwinmaker.model.UpdateReason.PRICING_MODE_UPDATE =>
      val r = PRICING_MODE_UPDATE
      r
    case software.amazon.awssdk.services.iottwinmaker.model.UpdateReason.OVERWRITTEN =>
      val r = OVERWRITTEN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iottwinmaker.model.UpdateReason {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.UpdateReason =
      software.amazon.awssdk.services.iottwinmaker.model.UpdateReason.UNKNOWN_TO_SDK_VERSION
  }
  case object DEFAULT extends zio.aws.iottwinmaker.model.UpdateReason {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.UpdateReason =
      software.amazon.awssdk.services.iottwinmaker.model.UpdateReason.DEFAULT
  }
  case object PRICING_TIER_UPDATE
      extends zio.aws.iottwinmaker.model.UpdateReason {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.UpdateReason =
      software.amazon.awssdk.services.iottwinmaker.model.UpdateReason.PRICING_TIER_UPDATE
  }
  case object ENTITY_COUNT_UPDATE
      extends zio.aws.iottwinmaker.model.UpdateReason {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.UpdateReason =
      software.amazon.awssdk.services.iottwinmaker.model.UpdateReason.ENTITY_COUNT_UPDATE
  }
  case object PRICING_MODE_UPDATE
      extends zio.aws.iottwinmaker.model.UpdateReason {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.UpdateReason =
      software.amazon.awssdk.services.iottwinmaker.model.UpdateReason.PRICING_MODE_UPDATE
  }
  case object OVERWRITTEN extends zio.aws.iottwinmaker.model.UpdateReason {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.UpdateReason =
      software.amazon.awssdk.services.iottwinmaker.model.UpdateReason.OVERWRITTEN
  }
}
