package zio.aws.iottwinmaker.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{
  TwinMakerArn,
  SceneCapability,
  Timestamp,
  S3Url,
  Description,
  Id
}
import scala.jdk.CollectionConverters._
final case class GetSceneResponse(
    workspaceId: Id,
    sceneId: Id,
    contentLocation: S3Url,
    arn: TwinMakerArn,
    creationDateTime: Timestamp,
    updateDateTime: Timestamp,
    description: Optional[Description] = Optional.Absent,
    capabilities: Optional[Iterable[SceneCapability]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetSceneResponse = {
    import GetSceneResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetSceneResponse
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .sceneId(Id.unwrap(sceneId): java.lang.String)
      .contentLocation(S3Url.unwrap(contentLocation): java.lang.String)
      .arn(TwinMakerArn.unwrap(arn): java.lang.String)
      .creationDateTime(Timestamp.unwrap(creationDateTime): Instant)
      .updateDateTime(Timestamp.unwrap(updateDateTime): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            SceneCapability.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.capabilities)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetSceneResponse.ReadOnly =
    zio.aws.iottwinmaker.model.GetSceneResponse.wrap(buildAwsValue())
}
object GetSceneResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetSceneResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetSceneResponse =
      zio.aws.iottwinmaker.model.GetSceneResponse(
        workspaceId,
        sceneId,
        contentLocation,
        arn,
        creationDateTime,
        updateDateTime,
        description.map(value => value),
        capabilities.map(value => value)
      )
    def workspaceId: Id
    def sceneId: Id
    def contentLocation: S3Url
    def arn: TwinMakerArn
    def creationDateTime: Timestamp
    def updateDateTime: Timestamp
    def description: Optional[Description]
    def capabilities: Optional[List[SceneCapability]]
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getSceneId: ZIO[Any, Nothing, Id] = ZIO.succeed(sceneId)
    def getContentLocation: ZIO[Any, Nothing, S3Url] =
      ZIO.succeed(contentLocation)
    def getArn: ZIO[Any, Nothing, TwinMakerArn] = ZIO.succeed(arn)
    def getCreationDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDateTime)
    def getUpdateDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(updateDateTime)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCapabilities: ZIO[Any, AwsError, List[SceneCapability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetSceneResponse
  ) extends zio.aws.iottwinmaker.model.GetSceneResponse.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val sceneId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.sceneId())
    override val contentLocation: S3Url =
      zio.aws.iottwinmaker.model.primitives.S3Url(impl.contentLocation())
    override val arn: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.arn())
    override val creationDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.creationDateTime())
    override val updateDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.updateDateTime())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val capabilities: Optional[List[SceneCapability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.primitives.SceneCapability(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetSceneResponse
  ): zio.aws.iottwinmaker.model.GetSceneResponse.ReadOnly = new Wrapper(impl)
}
