package zio.aws.iottwinmaker.model
import scala.jdk.CollectionConverters._
sealed trait SyncResourceState {
  def unwrap
      : software.amazon.awssdk.services.iottwinmaker.model.SyncResourceState
}
object SyncResourceState {
  def wrap(
      value: software.amazon.awssdk.services.iottwinmaker.model.SyncResourceState
  ): zio.aws.iottwinmaker.model.SyncResourceState = value match {
    case software.amazon.awssdk.services.iottwinmaker.model.SyncResourceState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iottwinmaker.model.SyncResourceState.INITIALIZING =>
      val r = INITIALIZING
      r
    case software.amazon.awssdk.services.iottwinmaker.model.SyncResourceState.PROCESSING =>
      val r = PROCESSING
      r
    case software.amazon.awssdk.services.iottwinmaker.model.SyncResourceState.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.iottwinmaker.model.SyncResourceState.IN_SYNC =>
      val r = IN_SYNC
      r
    case software.amazon.awssdk.services.iottwinmaker.model.SyncResourceState.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iottwinmaker.model.SyncResourceState {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.SyncResourceState =
      software.amazon.awssdk.services.iottwinmaker.model.SyncResourceState.UNKNOWN_TO_SDK_VERSION
  }
  case object INITIALIZING
      extends zio.aws.iottwinmaker.model.SyncResourceState {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.SyncResourceState =
      software.amazon.awssdk.services.iottwinmaker.model.SyncResourceState.INITIALIZING
  }
  case object PROCESSING extends zio.aws.iottwinmaker.model.SyncResourceState {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.SyncResourceState =
      software.amazon.awssdk.services.iottwinmaker.model.SyncResourceState.PROCESSING
  }
  case object DELETED extends zio.aws.iottwinmaker.model.SyncResourceState {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.SyncResourceState =
      software.amazon.awssdk.services.iottwinmaker.model.SyncResourceState.DELETED
  }
  case object IN_SYNC extends zio.aws.iottwinmaker.model.SyncResourceState {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.SyncResourceState =
      software.amazon.awssdk.services.iottwinmaker.model.SyncResourceState.IN_SYNC
  }
  case object ERROR extends zio.aws.iottwinmaker.model.SyncResourceState {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.SyncResourceState =
      software.amazon.awssdk.services.iottwinmaker.model.SyncResourceState.ERROR
  }
}
