package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.Name
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComponentPropertyGroupRequest(
    groupType: Optional[zio.aws.iottwinmaker.model.GroupType] = Optional.Absent,
    propertyNames: Optional[Iterable[Name]] = Optional.Absent,
    updateType: Optional[zio.aws.iottwinmaker.model.PropertyGroupUpdateType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ComponentPropertyGroupRequest = {
    import ComponentPropertyGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ComponentPropertyGroupRequest
      .builder()
      .optionallyWith(groupType.map(value => value.unwrap))(_.groupType)
      .optionallyWith(
        propertyNames.map(value =>
          value.map { item =>
            Name.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.propertyNames)
      .optionallyWith(updateType.map(value => value.unwrap))(_.updateType)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.ComponentPropertyGroupRequest.ReadOnly =
    zio.aws.iottwinmaker.model.ComponentPropertyGroupRequest
      .wrap(buildAwsValue())
}
object ComponentPropertyGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ComponentPropertyGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ComponentPropertyGroupRequest =
      zio.aws.iottwinmaker.model.ComponentPropertyGroupRequest(
        groupType.map(value => value),
        propertyNames.map(value => value),
        updateType.map(value => value)
      )
    def groupType: Optional[zio.aws.iottwinmaker.model.GroupType]
    def propertyNames: Optional[List[Name]]
    def updateType: Optional[zio.aws.iottwinmaker.model.PropertyGroupUpdateType]
    def getGroupType: ZIO[Any, AwsError, zio.aws.iottwinmaker.model.GroupType] =
      AwsError.unwrapOptionField("groupType", groupType)
    def getPropertyNames: ZIO[Any, AwsError, List[Name]] =
      AwsError.unwrapOptionField("propertyNames", propertyNames)
    def getUpdateType: ZIO[
      Any,
      AwsError,
      zio.aws.iottwinmaker.model.PropertyGroupUpdateType
    ] = AwsError.unwrapOptionField("updateType", updateType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ComponentPropertyGroupRequest
  ) extends zio.aws.iottwinmaker.model.ComponentPropertyGroupRequest.ReadOnly {
    override val groupType: Optional[zio.aws.iottwinmaker.model.GroupType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupType())
        .map(value => zio.aws.iottwinmaker.model.GroupType.wrap(value))
    override val propertyNames: Optional[List[Name]] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iottwinmaker.model.primitives.Name(item)
        }.toList
      )
    override val updateType
        : Optional[zio.aws.iottwinmaker.model.PropertyGroupUpdateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateType())
        .map(value =>
          zio.aws.iottwinmaker.model.PropertyGroupUpdateType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ComponentPropertyGroupRequest
  ): zio.aws.iottwinmaker.model.ComponentPropertyGroupRequest.ReadOnly =
    new Wrapper(impl)
}
