package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{ParentEntityId, ComponentTypeId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListEntitiesFilter(
    componentTypeId: Optional[ComponentTypeId] = Optional.Absent,
    externalId: Optional[String] = Optional.Absent,
    parentEntityId: Optional[ParentEntityId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesFilter = {
    import ListEntitiesFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesFilter
      .builder()
      .optionallyWith(
        componentTypeId.map(value =>
          ComponentTypeId.unwrap(value): java.lang.String
        )
      )(_.componentTypeId)
      .optionallyWith(externalId.map(value => value: java.lang.String))(
        _.externalId
      )
      .optionallyWith(
        parentEntityId.map(value =>
          ParentEntityId.unwrap(value): java.lang.String
        )
      )(_.parentEntityId)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ListEntitiesFilter.ReadOnly =
    zio.aws.iottwinmaker.model.ListEntitiesFilter.wrap(buildAwsValue())
}
object ListEntitiesFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ListEntitiesFilter =
      zio.aws.iottwinmaker.model.ListEntitiesFilter(
        componentTypeId.map(value => value),
        externalId.map(value => value),
        parentEntityId.map(value => value)
      )
    def componentTypeId: Optional[ComponentTypeId]
    def externalId: Optional[String]
    def parentEntityId: Optional[ParentEntityId]
    def getComponentTypeId: ZIO[Any, AwsError, ComponentTypeId] =
      AwsError.unwrapOptionField("componentTypeId", componentTypeId)
    def getExternalId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getParentEntityId: ZIO[Any, AwsError, ParentEntityId] =
      AwsError.unwrapOptionField("parentEntityId", parentEntityId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesFilter
  ) extends zio.aws.iottwinmaker.model.ListEntitiesFilter.ReadOnly {
    override val componentTypeId: Optional[ComponentTypeId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentTypeId())
        .map(value =>
          zio.aws.iottwinmaker.model.primitives.ComponentTypeId(value)
        )
    override val externalId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.externalId())
      .map(value => value: String)
    override val parentEntityId: Optional[ParentEntityId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentEntityId())
        .map(value =>
          zio.aws.iottwinmaker.model.primitives.ParentEntityId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesFilter
  ): zio.aws.iottwinmaker.model.ListEntitiesFilter.ReadOnly = new Wrapper(impl)
}
