package zio.aws.iottwinmaker.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{
  TwinMakerArn,
  Timestamp,
  ParentEntityId,
  Description,
  EntityId,
  Name,
  EntityName,
  Id
}
import scala.jdk.CollectionConverters._
final case class GetEntityResponse(
    arn: TwinMakerArn,
    components: Optional[
      Map[Name, zio.aws.iottwinmaker.model.ComponentResponse]
    ] = Optional.Absent,
    creationDateTime: Timestamp,
    description: Optional[Description] = Optional.Absent,
    entityId: EntityId,
    entityName: EntityName,
    hasChildEntities: Boolean,
    parentEntityId: ParentEntityId,
    status: zio.aws.iottwinmaker.model.Status,
    updateDateTime: Timestamp,
    workspaceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetEntityResponse = {
    import GetEntityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetEntityResponse
      .builder()
      .arn(TwinMakerArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        components.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.components)
      .creationDateTime(Timestamp.unwrap(creationDateTime): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .entityId(EntityId.unwrap(entityId): java.lang.String)
      .entityName(EntityName.unwrap(entityName): java.lang.String)
      .hasChildEntities(hasChildEntities: java.lang.Boolean)
      .parentEntityId(ParentEntityId.unwrap(parentEntityId): java.lang.String)
      .status(status.buildAwsValue())
      .updateDateTime(Timestamp.unwrap(updateDateTime): Instant)
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetEntityResponse.ReadOnly =
    zio.aws.iottwinmaker.model.GetEntityResponse.wrap(buildAwsValue())
}
object GetEntityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetEntityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetEntityResponse =
      zio.aws.iottwinmaker.model.GetEntityResponse(
        arn,
        components.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        creationDateTime,
        description.map(value => value),
        entityId,
        entityName,
        hasChildEntities,
        parentEntityId,
        status.asEditable,
        updateDateTime,
        workspaceId
      )
    def arn: TwinMakerArn
    def components: Optional[
      Map[Name, zio.aws.iottwinmaker.model.ComponentResponse.ReadOnly]
    ]
    def creationDateTime: Timestamp
    def description: Optional[Description]
    def entityId: EntityId
    def entityName: EntityName
    def hasChildEntities: Boolean
    def parentEntityId: ParentEntityId
    def status: zio.aws.iottwinmaker.model.Status.ReadOnly
    def updateDateTime: Timestamp
    def workspaceId: Id
    def getArn: ZIO[Any, Nothing, TwinMakerArn] = ZIO.succeed(arn)
    def getComponents: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.ComponentResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("components", components)
    def getCreationDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDateTime)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEntityId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(entityId)
    def getEntityName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(entityName)
    def getHasChildEntities: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(hasChildEntities)
    def getParentEntityId: ZIO[Any, Nothing, ParentEntityId] =
      ZIO.succeed(parentEntityId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.iottwinmaker.model.Status.ReadOnly] =
      ZIO.succeed(status)
    def getUpdateDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(updateDateTime)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetEntityResponse
  ) extends zio.aws.iottwinmaker.model.GetEntityResponse.ReadOnly {
    override val arn: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.arn())
    override val components: Optional[
      Map[Name, zio.aws.iottwinmaker.model.ComponentResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.components())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.ComponentResponse.wrap(value)
          })
          .toMap
      )
    override val creationDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.creationDateTime())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val entityId: EntityId =
      zio.aws.iottwinmaker.model.primitives.EntityId(impl.entityId())
    override val entityName: EntityName =
      zio.aws.iottwinmaker.model.primitives.EntityName(impl.entityName())
    override val hasChildEntities: Boolean = impl.hasChildEntities(): Boolean
    override val parentEntityId: ParentEntityId =
      zio.aws.iottwinmaker.model.primitives
        .ParentEntityId(impl.parentEntityId())
    override val status: zio.aws.iottwinmaker.model.Status.ReadOnly =
      zio.aws.iottwinmaker.model.Status.wrap(impl.status())
    override val updateDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.updateDateTime())
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetEntityResponse
  ): zio.aws.iottwinmaker.model.GetEntityResponse.ReadOnly = new Wrapper(impl)
}
