package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{TagKey, TwinMakerArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceARN: TwinMakerArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.UntagResourceRequest
      .builder()
      .resourceARN(TwinMakerArn.unwrap(resourceARN): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.UntagResourceRequest.ReadOnly =
    zio.aws.iottwinmaker.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.UntagResourceRequest =
      zio.aws.iottwinmaker.model.UntagResourceRequest(resourceARN, tagKeys)
    def resourceARN: TwinMakerArn
    def tagKeys: List[TagKey]
    def getResourceARN: ZIO[Any, Nothing, TwinMakerArn] =
      ZIO.succeed(resourceARN)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UntagResourceRequest
  ) extends zio.aws.iottwinmaker.model.UntagResourceRequest.ReadOnly {
    override val resourceARN: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.resourceARN())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.iottwinmaker.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UntagResourceRequest
  ): zio.aws.iottwinmaker.model.UntagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
