package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteSceneRequest(sceneId: Id, workspaceId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.DeleteSceneRequest = {
    import DeleteSceneRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.DeleteSceneRequest
      .builder()
      .sceneId(Id.unwrap(sceneId): java.lang.String)
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.DeleteSceneRequest.ReadOnly =
    zio.aws.iottwinmaker.model.DeleteSceneRequest.wrap(buildAwsValue())
}
object DeleteSceneRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.DeleteSceneRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.DeleteSceneRequest =
      zio.aws.iottwinmaker.model.DeleteSceneRequest(sceneId, workspaceId)
    def sceneId: Id
    def workspaceId: Id
    def getSceneId: ZIO[Any, Nothing, Id] = ZIO.succeed(sceneId)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DeleteSceneRequest
  ) extends zio.aws.iottwinmaker.model.DeleteSceneRequest.ReadOnly {
    override val sceneId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.sceneId())
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DeleteSceneRequest
  ): zio.aws.iottwinmaker.model.DeleteSceneRequest.ReadOnly = new Wrapper(impl)
}
