package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{Integer, Expression}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataValue(
    booleanValue: Optional[Boolean] = Optional.Absent,
    doubleValue: Optional[Double] = Optional.Absent,
    expression: Optional[Expression] = Optional.Absent,
    integerValue: Optional[Integer] = Optional.Absent,
    listValue: Optional[Iterable[zio.aws.iottwinmaker.model.DataValue]] =
      Optional.Absent,
    longValue: Optional[Long] = Optional.Absent,
    mapValue: Optional[Map[String, zio.aws.iottwinmaker.model.DataValue]] =
      Optional.Absent,
    relationshipValue: Optional[zio.aws.iottwinmaker.model.RelationshipValue] =
      Optional.Absent,
    stringValue: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.DataValue = {
    import DataValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.DataValue
      .builder()
      .optionallyWith(booleanValue.map(value => value: java.lang.Boolean))(
        _.booleanValue
      )
      .optionallyWith(doubleValue.map(value => value: java.lang.Double))(
        _.doubleValue
      )
      .optionallyWith(
        expression.map(value => Expression.unwrap(value): java.lang.String)
      )(_.expression)
      .optionallyWith(integerValue.map(value => value: java.lang.Integer))(
        _.integerValue
      )
      .optionallyWith(
        listValue.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.listValue)
      .optionallyWith(longValue.map(value => value: java.lang.Long))(
        _.longValue
      )
      .optionallyWith(
        mapValue.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.mapValue)
      .optionallyWith(relationshipValue.map(value => value.buildAwsValue()))(
        _.relationshipValue
      )
      .optionallyWith(stringValue.map(value => value: java.lang.String))(
        _.stringValue
      )
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.DataValue.ReadOnly =
    zio.aws.iottwinmaker.model.DataValue.wrap(buildAwsValue())
}
object DataValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.DataValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.DataValue =
      zio.aws.iottwinmaker.model.DataValue(
        booleanValue.map(value => value),
        doubleValue.map(value => value),
        expression.map(value => value),
        integerValue.map(value => value),
        listValue.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        longValue.map(value => value),
        mapValue.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        relationshipValue.map(value => value.asEditable),
        stringValue.map(value => value)
      )
    def booleanValue: Optional[Boolean]
    def doubleValue: Optional[Double]
    def expression: Optional[Expression]
    def integerValue: Optional[Integer]
    def listValue: Optional[List[zio.aws.iottwinmaker.model.DataValue.ReadOnly]]
    def longValue: Optional[Long]
    def mapValue
        : Optional[Map[String, zio.aws.iottwinmaker.model.DataValue.ReadOnly]]
    def relationshipValue
        : Optional[zio.aws.iottwinmaker.model.RelationshipValue.ReadOnly]
    def stringValue: Optional[String]
    def getBooleanValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("booleanValue", booleanValue)
    def getDoubleValue: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("doubleValue", doubleValue)
    def getExpression: ZIO[Any, AwsError, Expression] =
      AwsError.unwrapOptionField("expression", expression)
    def getIntegerValue: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("integerValue", integerValue)
    def getListValue: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.DataValue.ReadOnly
    ]] = AwsError.unwrapOptionField("listValue", listValue)
    def getLongValue: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("longValue", longValue)
    def getMapValue: ZIO[Any, AwsError, Map[
      String,
      zio.aws.iottwinmaker.model.DataValue.ReadOnly
    ]] = AwsError.unwrapOptionField("mapValue", mapValue)
    def getRelationshipValue: ZIO[
      Any,
      AwsError,
      zio.aws.iottwinmaker.model.RelationshipValue.ReadOnly
    ] = AwsError.unwrapOptionField("relationshipValue", relationshipValue)
    def getStringValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stringValue", stringValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DataValue
  ) extends zio.aws.iottwinmaker.model.DataValue.ReadOnly {
    override val booleanValue: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.booleanValue())
      .map(value => value: Boolean)
    override val doubleValue: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.doubleValue())
      .map(value => value: Double)
    override val expression: Optional[Expression] = zio.aws.core.internal
      .optionalFromNullable(impl.expression())
      .map(value => zio.aws.iottwinmaker.model.primitives.Expression(value))
    override val integerValue: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.integerValue())
      .map(value => value: Integer)
    override val listValue
        : Optional[List[zio.aws.iottwinmaker.model.DataValue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.listValue())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.DataValue.wrap(item)
          }.toList
        )
    override val longValue: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.longValue())
      .map(value => value: Long)
    override val mapValue
        : Optional[Map[String, zio.aws.iottwinmaker.model.DataValue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mapValue())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> zio.aws.iottwinmaker.model.DataValue.wrap(value)
            })
            .toMap
        )
    override val relationshipValue
        : Optional[zio.aws.iottwinmaker.model.RelationshipValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relationshipValue())
        .map(value => zio.aws.iottwinmaker.model.RelationshipValue.wrap(value))
    override val stringValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stringValue())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DataValue
  ): zio.aws.iottwinmaker.model.DataValue.ReadOnly = new Wrapper(impl)
}
