package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataType(
    allowedValues: Optional[Iterable[zio.aws.iottwinmaker.model.DataValue]] =
      Optional.Absent,
    nestedType: Optional[zio.aws.iottwinmaker.model.DataType] = Optional.Absent,
    relationship: Optional[zio.aws.iottwinmaker.model.Relationship] =
      Optional.Absent,
    `type`: zio.aws.iottwinmaker.model.Type,
    unitOfMeasure: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.DataType = {
    import DataType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.DataType
      .builder()
      .optionallyWith(
        allowedValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.allowedValues)
      .optionallyWith(nestedType.map(value => value.buildAwsValue()))(
        _.nestedType
      )
      .optionallyWith(relationship.map(value => value.buildAwsValue()))(
        _.relationship
      )
      .`type`(`type`.unwrap)
      .optionallyWith(unitOfMeasure.map(value => value: java.lang.String))(
        _.unitOfMeasure
      )
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.DataType.ReadOnly =
    zio.aws.iottwinmaker.model.DataType.wrap(buildAwsValue())
}
object DataType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.DataType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.DataType =
      zio.aws.iottwinmaker.model.DataType(
        allowedValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nestedType.map(value => value.asEditable),
        relationship.map(value => value.asEditable),
        `type`,
        unitOfMeasure.map(value => value)
      )
    def allowedValues
        : Optional[List[zio.aws.iottwinmaker.model.DataValue.ReadOnly]]
    def nestedType: Optional[zio.aws.iottwinmaker.model.DataType.ReadOnly]
    def relationship: Optional[zio.aws.iottwinmaker.model.Relationship.ReadOnly]
    def `type`: zio.aws.iottwinmaker.model.Type
    def unitOfMeasure: Optional[String]
    def getAllowedValues: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.DataValue.ReadOnly
    ]] = AwsError.unwrapOptionField("allowedValues", allowedValues)
    def getNestedType
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.DataType.ReadOnly] =
      AwsError.unwrapOptionField("nestedType", nestedType)
    def getRelationship
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.Relationship.ReadOnly] =
      AwsError.unwrapOptionField("relationship", relationship)
    def getType: ZIO[Any, Nothing, zio.aws.iottwinmaker.model.Type] =
      ZIO.succeed(`type`)
    def getUnitOfMeasure: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("unitOfMeasure", unitOfMeasure)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DataType
  ) extends zio.aws.iottwinmaker.model.DataType.ReadOnly {
    override val allowedValues
        : Optional[List[zio.aws.iottwinmaker.model.DataValue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowedValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.DataValue.wrap(item)
          }.toList
        )
    override val nestedType
        : Optional[zio.aws.iottwinmaker.model.DataType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nestedType())
        .map(value => zio.aws.iottwinmaker.model.DataType.wrap(value))
    override val relationship
        : Optional[zio.aws.iottwinmaker.model.Relationship.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relationship())
        .map(value => zio.aws.iottwinmaker.model.Relationship.wrap(value))
    override val `type`: zio.aws.iottwinmaker.model.Type =
      zio.aws.iottwinmaker.model.Type.wrap(impl.`type`())
    override val unitOfMeasure: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.unitOfMeasure())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DataType
  ): zio.aws.iottwinmaker.model.DataType.ReadOnly = new Wrapper(impl)
}
