package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PropertyValueEntry(
    entityPropertyReference: zio.aws.iottwinmaker.model.EntityPropertyReference,
    propertyValues: Optional[
      Iterable[zio.aws.iottwinmaker.model.PropertyValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.PropertyValueEntry = {
    import PropertyValueEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.PropertyValueEntry
      .builder()
      .entityPropertyReference(entityPropertyReference.buildAwsValue())
      .optionallyWith(
        propertyValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.propertyValues)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.PropertyValueEntry.ReadOnly =
    zio.aws.iottwinmaker.model.PropertyValueEntry.wrap(buildAwsValue())
}
object PropertyValueEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.PropertyValueEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.PropertyValueEntry =
      zio.aws.iottwinmaker.model.PropertyValueEntry(
        entityPropertyReference.asEditable,
        propertyValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def entityPropertyReference
        : zio.aws.iottwinmaker.model.EntityPropertyReference.ReadOnly
    def propertyValues
        : Optional[List[zio.aws.iottwinmaker.model.PropertyValue.ReadOnly]]
    def getEntityPropertyReference: ZIO[
      Any,
      Nothing,
      zio.aws.iottwinmaker.model.EntityPropertyReference.ReadOnly
    ] = ZIO.succeed(entityPropertyReference)
    def getPropertyValues: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.PropertyValue.ReadOnly
    ]] = AwsError.unwrapOptionField("propertyValues", propertyValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyValueEntry
  ) extends zio.aws.iottwinmaker.model.PropertyValueEntry.ReadOnly {
    override val entityPropertyReference
        : zio.aws.iottwinmaker.model.EntityPropertyReference.ReadOnly =
      zio.aws.iottwinmaker.model.EntityPropertyReference
        .wrap(impl.entityPropertyReference())
    override val propertyValues
        : Optional[List[zio.aws.iottwinmaker.model.PropertyValue.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propertyValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.PropertyValue.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyValueEntry
  ): zio.aws.iottwinmaker.model.PropertyValueEntry.ReadOnly = new Wrapper(impl)
}
