package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.ParentEntityId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ParentEntityUpdateRequest(
    parentEntityId: Optional[ParentEntityId] = Optional.Absent,
    updateType: zio.aws.iottwinmaker.model.ParentEntityUpdateType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ParentEntityUpdateRequest = {
    import ParentEntityUpdateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ParentEntityUpdateRequest
      .builder()
      .optionallyWith(
        parentEntityId.map(value =>
          ParentEntityId.unwrap(value): java.lang.String
        )
      )(_.parentEntityId)
      .updateType(updateType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.ParentEntityUpdateRequest.ReadOnly =
    zio.aws.iottwinmaker.model.ParentEntityUpdateRequest.wrap(buildAwsValue())
}
object ParentEntityUpdateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ParentEntityUpdateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ParentEntityUpdateRequest =
      zio.aws.iottwinmaker.model.ParentEntityUpdateRequest(
        parentEntityId.map(value => value),
        updateType
      )
    def parentEntityId: Optional[ParentEntityId]
    def updateType: zio.aws.iottwinmaker.model.ParentEntityUpdateType
    def getParentEntityId: ZIO[Any, AwsError, ParentEntityId] =
      AwsError.unwrapOptionField("parentEntityId", parentEntityId)
    def getUpdateType
        : ZIO[Any, Nothing, zio.aws.iottwinmaker.model.ParentEntityUpdateType] =
      ZIO.succeed(updateType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ParentEntityUpdateRequest
  ) extends zio.aws.iottwinmaker.model.ParentEntityUpdateRequest.ReadOnly {
    override val parentEntityId: Optional[ParentEntityId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentEntityId())
        .map(value =>
          zio.aws.iottwinmaker.model.primitives.ParentEntityId(value)
        )
    override val updateType: zio.aws.iottwinmaker.model.ParentEntityUpdateType =
      zio.aws.iottwinmaker.model.ParentEntityUpdateType.wrap(impl.updateType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ParentEntityUpdateRequest
  ): zio.aws.iottwinmaker.model.ParentEntityUpdateRequest.ReadOnly =
    new Wrapper(impl)
}
