package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.Name
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FunctionResponse(
    implementedBy: Optional[zio.aws.iottwinmaker.model.DataConnector] =
      Optional.Absent,
    isInherited: Optional[Boolean] = Optional.Absent,
    requiredProperties: Optional[Iterable[Name]] = Optional.Absent,
    scope: Optional[zio.aws.iottwinmaker.model.Scope] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.FunctionResponse = {
    import FunctionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.FunctionResponse
      .builder()
      .optionallyWith(implementedBy.map(value => value.buildAwsValue()))(
        _.implementedBy
      )
      .optionallyWith(isInherited.map(value => value: java.lang.Boolean))(
        _.isInherited
      )
      .optionallyWith(
        requiredProperties.map(value =>
          value.map { item =>
            Name.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.requiredProperties)
      .optionallyWith(scope.map(value => value.unwrap))(_.scope)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.FunctionResponse.ReadOnly =
    zio.aws.iottwinmaker.model.FunctionResponse.wrap(buildAwsValue())
}
object FunctionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.FunctionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.FunctionResponse =
      zio.aws.iottwinmaker.model.FunctionResponse(
        implementedBy.map(value => value.asEditable),
        isInherited.map(value => value),
        requiredProperties.map(value => value),
        scope.map(value => value)
      )
    def implementedBy
        : Optional[zio.aws.iottwinmaker.model.DataConnector.ReadOnly]
    def isInherited: Optional[Boolean]
    def requiredProperties: Optional[List[Name]]
    def scope: Optional[zio.aws.iottwinmaker.model.Scope]
    def getImplementedBy: ZIO[
      Any,
      AwsError,
      zio.aws.iottwinmaker.model.DataConnector.ReadOnly
    ] = AwsError.unwrapOptionField("implementedBy", implementedBy)
    def getIsInherited: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isInherited", isInherited)
    def getRequiredProperties: ZIO[Any, AwsError, List[Name]] =
      AwsError.unwrapOptionField("requiredProperties", requiredProperties)
    def getScope: ZIO[Any, AwsError, zio.aws.iottwinmaker.model.Scope] =
      AwsError.unwrapOptionField("scope", scope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.FunctionResponse
  ) extends zio.aws.iottwinmaker.model.FunctionResponse.ReadOnly {
    override val implementedBy
        : Optional[zio.aws.iottwinmaker.model.DataConnector.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.implementedBy())
        .map(value => zio.aws.iottwinmaker.model.DataConnector.wrap(value))
    override val isInherited: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isInherited())
      .map(value => value: Boolean)
    override val requiredProperties: Optional[List[Name]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requiredProperties())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.primitives.Name(item)
          }.toList
        )
    override val scope: Optional[zio.aws.iottwinmaker.model.Scope] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scope())
        .map(value => zio.aws.iottwinmaker.model.Scope.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.FunctionResponse
  ): zio.aws.iottwinmaker.model.FunctionResponse.ReadOnly = new Wrapper(impl)
}
