package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataConnector(
    isNative: Optional[Boolean] = Optional.Absent,
    lambda: Optional[zio.aws.iottwinmaker.model.LambdaFunction] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.DataConnector = {
    import DataConnector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.DataConnector
      .builder()
      .optionallyWith(isNative.map(value => value: java.lang.Boolean))(
        _.isNative
      )
      .optionallyWith(lambda.map(value => value.buildAwsValue()))(_.lambda)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.DataConnector.ReadOnly =
    zio.aws.iottwinmaker.model.DataConnector.wrap(buildAwsValue())
}
object DataConnector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.DataConnector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.DataConnector =
      zio.aws.iottwinmaker.model.DataConnector(
        isNative.map(value => value),
        lambda.map(value => value.asEditable)
      )
    def isNative: Optional[Boolean]
    def lambda: Optional[zio.aws.iottwinmaker.model.LambdaFunction.ReadOnly]
    def getIsNative: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isNative", isNative)
    def getLambda: ZIO[
      Any,
      AwsError,
      zio.aws.iottwinmaker.model.LambdaFunction.ReadOnly
    ] = AwsError.unwrapOptionField("lambda", lambda)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DataConnector
  ) extends zio.aws.iottwinmaker.model.DataConnector.ReadOnly {
    override val isNative: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isNative())
      .map(value => value: Boolean)
    override val lambda
        : Optional[zio.aws.iottwinmaker.model.LambdaFunction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambda())
        .map(value => zio.aws.iottwinmaker.model.LambdaFunction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DataConnector
  ): zio.aws.iottwinmaker.model.DataConnector.ReadOnly = new Wrapper(impl)
}
