package zio.aws.iottwinmaker
import zio.aws.iottwinmaker.model.ListTagsForResourceResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.iottwinmaker.model.{
  ListComponentTypesRequest,
  GetComponentTypeResponse,
  DeleteSceneResponse,
  CreateWorkspaceResponse,
  GetWorkspaceResponse,
  CreateWorkspaceRequest,
  CreateSceneResponse,
  BatchPutPropertyValuesRequest,
  CreateEntityResponse,
  DeleteWorkspaceRequest,
  ListWorkspacesRequest,
  CreateComponentTypeRequest,
  GetPropertyValueHistoryResponse,
  GetWorkspaceRequest,
  CreateEntityRequest,
  GetComponentTypeRequest,
  GetPropertyValueResponse,
  GetSceneRequest,
  DeleteComponentTypeRequest,
  DeleteWorkspaceResponse,
  ListTagsForResourceRequest,
  ListWorkspacesResponse,
  BatchPutPropertyValuesResponse,
  GetPropertyValueHistoryRequest,
  UpdateSceneRequest,
  DeleteEntityRequest,
  ListEntitiesResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  UpdateEntityResponse,
  UpdateComponentTypeRequest,
  ListEntitiesRequest,
  ListComponentTypesResponse,
  CreateSceneRequest,
  DeleteEntityResponse,
  UpdateWorkspaceResponse,
  UpdateEntityRequest,
  UntagResourceRequest,
  UpdateSceneResponse,
  GetSceneResponse,
  DeleteComponentTypeResponse,
  UpdateComponentTypeResponse,
  GetEntityResponse,
  CreateComponentTypeResponse,
  TagResourceResponse,
  UpdateWorkspaceRequest,
  GetEntityRequest,
  TagResourceRequest,
  GetPropertyValueRequest,
  ListScenesResponse,
  DeleteSceneRequest,
  ListScenesRequest
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.iottwinmaker.{
  IoTTwinMakerAsyncClientBuilder,
  IoTTwinMakerAsyncClient
}
import scala.jdk.CollectionConverters._
trait IoTTwinMaker extends AspectSupport[IoTTwinMaker] {
  val api: IoTTwinMakerAsyncClient
  def createComponentType(
      request: zio.aws.iottwinmaker.model.CreateComponentTypeRequest
  ): IO[
    AwsError,
    zio.aws.iottwinmaker.model.CreateComponentTypeResponse.ReadOnly
  ]
  def listEntities(
      request: zio.aws.iottwinmaker.model.ListEntitiesRequest
  ): IO[AwsError, zio.aws.iottwinmaker.model.ListEntitiesResponse.ReadOnly]
  def deleteEntity(
      request: zio.aws.iottwinmaker.model.DeleteEntityRequest
  ): IO[AwsError, zio.aws.iottwinmaker.model.DeleteEntityResponse.ReadOnly]
  def createWorkspace(
      request: zio.aws.iottwinmaker.model.CreateWorkspaceRequest
  ): IO[AwsError, zio.aws.iottwinmaker.model.CreateWorkspaceResponse.ReadOnly]
  def deleteScene(
      request: zio.aws.iottwinmaker.model.DeleteSceneRequest
  ): IO[AwsError, zio.aws.iottwinmaker.model.DeleteSceneResponse.ReadOnly]
  def listComponentTypes(
      request: zio.aws.iottwinmaker.model.ListComponentTypesRequest
  ): IO[
    AwsError,
    zio.aws.iottwinmaker.model.ListComponentTypesResponse.ReadOnly
  ]
  def listWorkspaces(
      request: zio.aws.iottwinmaker.model.ListWorkspacesRequest
  ): IO[AwsError, zio.aws.iottwinmaker.model.ListWorkspacesResponse.ReadOnly]
  def getComponentType(
      request: zio.aws.iottwinmaker.model.GetComponentTypeRequest
  ): IO[AwsError, zio.aws.iottwinmaker.model.GetComponentTypeResponse.ReadOnly]
  def deleteComponentType(
      request: zio.aws.iottwinmaker.model.DeleteComponentTypeRequest
  ): IO[
    AwsError,
    zio.aws.iottwinmaker.model.DeleteComponentTypeResponse.ReadOnly
  ]
  def createScene(
      request: zio.aws.iottwinmaker.model.CreateSceneRequest
  ): IO[AwsError, zio.aws.iottwinmaker.model.CreateSceneResponse.ReadOnly]
  def getScene(
      request: zio.aws.iottwinmaker.model.GetSceneRequest
  ): IO[AwsError, zio.aws.iottwinmaker.model.GetSceneResponse.ReadOnly]
  def updateScene(
      request: zio.aws.iottwinmaker.model.UpdateSceneRequest
  ): IO[AwsError, zio.aws.iottwinmaker.model.UpdateSceneResponse.ReadOnly]
  def untagResource(
      request: zio.aws.iottwinmaker.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.iottwinmaker.model.UntagResourceResponse.ReadOnly]
  def getEntity(
      request: zio.aws.iottwinmaker.model.GetEntityRequest
  ): IO[AwsError, zio.aws.iottwinmaker.model.GetEntityResponse.ReadOnly]
  def updateEntity(
      request: zio.aws.iottwinmaker.model.UpdateEntityRequest
  ): IO[AwsError, zio.aws.iottwinmaker.model.UpdateEntityResponse.ReadOnly]
  def createEntity(
      request: zio.aws.iottwinmaker.model.CreateEntityRequest
  ): IO[AwsError, zio.aws.iottwinmaker.model.CreateEntityResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.iottwinmaker.model.ListTagsForResourceRequest
  ): IO[AwsError, ReadOnly]
  def tagResource(
      request: zio.aws.iottwinmaker.model.TagResourceRequest
  ): IO[AwsError, zio.aws.iottwinmaker.model.TagResourceResponse.ReadOnly]
  def batchPutPropertyValues(
      request: zio.aws.iottwinmaker.model.BatchPutPropertyValuesRequest
  ): IO[
    AwsError,
    zio.aws.iottwinmaker.model.BatchPutPropertyValuesResponse.ReadOnly
  ]
  def deleteWorkspace(
      request: zio.aws.iottwinmaker.model.DeleteWorkspaceRequest
  ): IO[AwsError, zio.aws.iottwinmaker.model.DeleteWorkspaceResponse.ReadOnly]
  def updateComponentType(
      request: zio.aws.iottwinmaker.model.UpdateComponentTypeRequest
  ): IO[
    AwsError,
    zio.aws.iottwinmaker.model.UpdateComponentTypeResponse.ReadOnly
  ]
  def getPropertyValueHistory(
      request: zio.aws.iottwinmaker.model.GetPropertyValueHistoryRequest
  ): IO[
    AwsError,
    zio.aws.iottwinmaker.model.GetPropertyValueHistoryResponse.ReadOnly
  ]
  def getWorkspace(
      request: zio.aws.iottwinmaker.model.GetWorkspaceRequest
  ): IO[AwsError, zio.aws.iottwinmaker.model.GetWorkspaceResponse.ReadOnly]
  def listScenes(
      request: zio.aws.iottwinmaker.model.ListScenesRequest
  ): IO[AwsError, zio.aws.iottwinmaker.model.ListScenesResponse.ReadOnly]
  def updateWorkspace(
      request: zio.aws.iottwinmaker.model.UpdateWorkspaceRequest
  ): IO[AwsError, zio.aws.iottwinmaker.model.UpdateWorkspaceResponse.ReadOnly]
  def getPropertyValue(
      request: zio.aws.iottwinmaker.model.GetPropertyValueRequest
  ): IO[AwsError, zio.aws.iottwinmaker.model.GetPropertyValueResponse.ReadOnly]
}
object IoTTwinMaker {
  val live: ZLayer[AwsConfig, java.lang.Throwable, IoTTwinMaker] = customized(
    identity
  )
  def customized(
      customization: IoTTwinMakerAsyncClientBuilder => IoTTwinMakerAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, IoTTwinMaker] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: IoTTwinMakerAsyncClientBuilder => IoTTwinMakerAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, IoTTwinMaker] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = IoTTwinMakerAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[IoTTwinMakerAsyncClient, IoTTwinMakerAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      IoTTwinMakerAsyncClient,
      IoTTwinMakerAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new IoTTwinMakerImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class IoTTwinMakerImpl[R](
      override val api: IoTTwinMakerAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends IoTTwinMaker
      with AwsServiceBase[R] {
    override val serviceName: String = "IoTTwinMaker"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): IoTTwinMakerImpl[R1] = new IoTTwinMakerImpl(api, newAspect, r)
    def createComponentType(
        request: zio.aws.iottwinmaker.model.CreateComponentTypeRequest
    ): IO[
      AwsError,
      zio.aws.iottwinmaker.model.CreateComponentTypeResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateComponentTypeRequest,
      CreateComponentTypeResponse
    ]("createComponentType", api.createComponentType)(request.buildAwsValue())
      .map(zio.aws.iottwinmaker.model.CreateComponentTypeResponse.wrap)
      .provideEnvironment(r)
    def listEntities(
        request: zio.aws.iottwinmaker.model.ListEntitiesRequest
    ): IO[AwsError, zio.aws.iottwinmaker.model.ListEntitiesResponse.ReadOnly] =
      asyncRequestResponse[ListEntitiesRequest, ListEntitiesResponse](
        "listEntities",
        api.listEntities
      )(request.buildAwsValue())
        .map(zio.aws.iottwinmaker.model.ListEntitiesResponse.wrap)
        .provideEnvironment(r)
    def deleteEntity(
        request: zio.aws.iottwinmaker.model.DeleteEntityRequest
    ): IO[AwsError, zio.aws.iottwinmaker.model.DeleteEntityResponse.ReadOnly] =
      asyncRequestResponse[DeleteEntityRequest, DeleteEntityResponse](
        "deleteEntity",
        api.deleteEntity
      )(request.buildAwsValue())
        .map(zio.aws.iottwinmaker.model.DeleteEntityResponse.wrap)
        .provideEnvironment(r)
    def createWorkspace(
        request: zio.aws.iottwinmaker.model.CreateWorkspaceRequest
    ): IO[
      AwsError,
      zio.aws.iottwinmaker.model.CreateWorkspaceResponse.ReadOnly
    ] = asyncRequestResponse[CreateWorkspaceRequest, CreateWorkspaceResponse](
      "createWorkspace",
      api.createWorkspace
    )(request.buildAwsValue())
      .map(zio.aws.iottwinmaker.model.CreateWorkspaceResponse.wrap)
      .provideEnvironment(r)
    def deleteScene(
        request: zio.aws.iottwinmaker.model.DeleteSceneRequest
    ): IO[AwsError, zio.aws.iottwinmaker.model.DeleteSceneResponse.ReadOnly] =
      asyncRequestResponse[DeleteSceneRequest, DeleteSceneResponse](
        "deleteScene",
        api.deleteScene
      )(request.buildAwsValue())
        .map(zio.aws.iottwinmaker.model.DeleteSceneResponse.wrap)
        .provideEnvironment(r)
    def listComponentTypes(
        request: zio.aws.iottwinmaker.model.ListComponentTypesRequest
    ): IO[
      AwsError,
      zio.aws.iottwinmaker.model.ListComponentTypesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListComponentTypesRequest,
      ListComponentTypesResponse
    ]("listComponentTypes", api.listComponentTypes)(request.buildAwsValue())
      .map(zio.aws.iottwinmaker.model.ListComponentTypesResponse.wrap)
      .provideEnvironment(r)
    def listWorkspaces(
        request: zio.aws.iottwinmaker.model.ListWorkspacesRequest
    ): IO[
      AwsError,
      zio.aws.iottwinmaker.model.ListWorkspacesResponse.ReadOnly
    ] = asyncRequestResponse[ListWorkspacesRequest, ListWorkspacesResponse](
      "listWorkspaces",
      api.listWorkspaces
    )(request.buildAwsValue())
      .map(zio.aws.iottwinmaker.model.ListWorkspacesResponse.wrap)
      .provideEnvironment(r)
    def getComponentType(
        request: zio.aws.iottwinmaker.model.GetComponentTypeRequest
    ): IO[
      AwsError,
      zio.aws.iottwinmaker.model.GetComponentTypeResponse.ReadOnly
    ] = asyncRequestResponse[GetComponentTypeRequest, GetComponentTypeResponse](
      "getComponentType",
      api.getComponentType
    )(request.buildAwsValue())
      .map(zio.aws.iottwinmaker.model.GetComponentTypeResponse.wrap)
      .provideEnvironment(r)
    def deleteComponentType(
        request: zio.aws.iottwinmaker.model.DeleteComponentTypeRequest
    ): IO[
      AwsError,
      zio.aws.iottwinmaker.model.DeleteComponentTypeResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteComponentTypeRequest,
      DeleteComponentTypeResponse
    ]("deleteComponentType", api.deleteComponentType)(request.buildAwsValue())
      .map(zio.aws.iottwinmaker.model.DeleteComponentTypeResponse.wrap)
      .provideEnvironment(r)
    def createScene(
        request: zio.aws.iottwinmaker.model.CreateSceneRequest
    ): IO[AwsError, zio.aws.iottwinmaker.model.CreateSceneResponse.ReadOnly] =
      asyncRequestResponse[CreateSceneRequest, CreateSceneResponse](
        "createScene",
        api.createScene
      )(request.buildAwsValue())
        .map(zio.aws.iottwinmaker.model.CreateSceneResponse.wrap)
        .provideEnvironment(r)
    def getScene(
        request: zio.aws.iottwinmaker.model.GetSceneRequest
    ): IO[AwsError, zio.aws.iottwinmaker.model.GetSceneResponse.ReadOnly] =
      asyncRequestResponse[GetSceneRequest, GetSceneResponse](
        "getScene",
        api.getScene
      )(request.buildAwsValue())
        .map(zio.aws.iottwinmaker.model.GetSceneResponse.wrap)
        .provideEnvironment(r)
    def updateScene(
        request: zio.aws.iottwinmaker.model.UpdateSceneRequest
    ): IO[AwsError, zio.aws.iottwinmaker.model.UpdateSceneResponse.ReadOnly] =
      asyncRequestResponse[UpdateSceneRequest, UpdateSceneResponse](
        "updateScene",
        api.updateScene
      )(request.buildAwsValue())
        .map(zio.aws.iottwinmaker.model.UpdateSceneResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.iottwinmaker.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.iottwinmaker.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.iottwinmaker.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def getEntity(
        request: zio.aws.iottwinmaker.model.GetEntityRequest
    ): IO[AwsError, zio.aws.iottwinmaker.model.GetEntityResponse.ReadOnly] =
      asyncRequestResponse[GetEntityRequest, GetEntityResponse](
        "getEntity",
        api.getEntity
      )(request.buildAwsValue())
        .map(zio.aws.iottwinmaker.model.GetEntityResponse.wrap)
        .provideEnvironment(r)
    def updateEntity(
        request: zio.aws.iottwinmaker.model.UpdateEntityRequest
    ): IO[AwsError, zio.aws.iottwinmaker.model.UpdateEntityResponse.ReadOnly] =
      asyncRequestResponse[UpdateEntityRequest, UpdateEntityResponse](
        "updateEntity",
        api.updateEntity
      )(request.buildAwsValue())
        .map(zio.aws.iottwinmaker.model.UpdateEntityResponse.wrap)
        .provideEnvironment(r)
    def createEntity(
        request: zio.aws.iottwinmaker.model.CreateEntityRequest
    ): IO[AwsError, zio.aws.iottwinmaker.model.CreateEntityResponse.ReadOnly] =
      asyncRequestResponse[CreateEntityRequest, CreateEntityResponse](
        "createEntity",
        api.createEntity
      )(request.buildAwsValue())
        .map(zio.aws.iottwinmaker.model.CreateEntityResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.iottwinmaker.model.ListTagsForResourceRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.iottwinmaker.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.iottwinmaker.model.TagResourceRequest
    ): IO[AwsError, zio.aws.iottwinmaker.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.iottwinmaker.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def batchPutPropertyValues(
        request: zio.aws.iottwinmaker.model.BatchPutPropertyValuesRequest
    ): IO[
      AwsError,
      zio.aws.iottwinmaker.model.BatchPutPropertyValuesResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchPutPropertyValuesRequest,
      BatchPutPropertyValuesResponse
    ]("batchPutPropertyValues", api.batchPutPropertyValues)(
      request.buildAwsValue()
    ).map(zio.aws.iottwinmaker.model.BatchPutPropertyValuesResponse.wrap)
      .provideEnvironment(r)
    def deleteWorkspace(
        request: zio.aws.iottwinmaker.model.DeleteWorkspaceRequest
    ): IO[
      AwsError,
      zio.aws.iottwinmaker.model.DeleteWorkspaceResponse.ReadOnly
    ] = asyncRequestResponse[DeleteWorkspaceRequest, DeleteWorkspaceResponse](
      "deleteWorkspace",
      api.deleteWorkspace
    )(request.buildAwsValue())
      .map(zio.aws.iottwinmaker.model.DeleteWorkspaceResponse.wrap)
      .provideEnvironment(r)
    def updateComponentType(
        request: zio.aws.iottwinmaker.model.UpdateComponentTypeRequest
    ): IO[
      AwsError,
      zio.aws.iottwinmaker.model.UpdateComponentTypeResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateComponentTypeRequest,
      UpdateComponentTypeResponse
    ]("updateComponentType", api.updateComponentType)(request.buildAwsValue())
      .map(zio.aws.iottwinmaker.model.UpdateComponentTypeResponse.wrap)
      .provideEnvironment(r)
    def getPropertyValueHistory(
        request: zio.aws.iottwinmaker.model.GetPropertyValueHistoryRequest
    ): IO[
      AwsError,
      zio.aws.iottwinmaker.model.GetPropertyValueHistoryResponse.ReadOnly
    ] = asyncRequestResponse[
      GetPropertyValueHistoryRequest,
      GetPropertyValueHistoryResponse
    ]("getPropertyValueHistory", api.getPropertyValueHistory)(
      request.buildAwsValue()
    ).map(zio.aws.iottwinmaker.model.GetPropertyValueHistoryResponse.wrap)
      .provideEnvironment(r)
    def getWorkspace(
        request: zio.aws.iottwinmaker.model.GetWorkspaceRequest
    ): IO[AwsError, zio.aws.iottwinmaker.model.GetWorkspaceResponse.ReadOnly] =
      asyncRequestResponse[GetWorkspaceRequest, GetWorkspaceResponse](
        "getWorkspace",
        api.getWorkspace
      )(request.buildAwsValue())
        .map(zio.aws.iottwinmaker.model.GetWorkspaceResponse.wrap)
        .provideEnvironment(r)
    def listScenes(
        request: zio.aws.iottwinmaker.model.ListScenesRequest
    ): IO[AwsError, zio.aws.iottwinmaker.model.ListScenesResponse.ReadOnly] =
      asyncRequestResponse[ListScenesRequest, ListScenesResponse](
        "listScenes",
        api.listScenes
      )(request.buildAwsValue())
        .map(zio.aws.iottwinmaker.model.ListScenesResponse.wrap)
        .provideEnvironment(r)
    def updateWorkspace(
        request: zio.aws.iottwinmaker.model.UpdateWorkspaceRequest
    ): IO[
      AwsError,
      zio.aws.iottwinmaker.model.UpdateWorkspaceResponse.ReadOnly
    ] = asyncRequestResponse[UpdateWorkspaceRequest, UpdateWorkspaceResponse](
      "updateWorkspace",
      api.updateWorkspace
    )(request.buildAwsValue())
      .map(zio.aws.iottwinmaker.model.UpdateWorkspaceResponse.wrap)
      .provideEnvironment(r)
    def getPropertyValue(
        request: zio.aws.iottwinmaker.model.GetPropertyValueRequest
    ): IO[
      AwsError,
      zio.aws.iottwinmaker.model.GetPropertyValueResponse.ReadOnly
    ] = asyncRequestResponse[GetPropertyValueRequest, GetPropertyValueResponse](
      "getPropertyValue",
      api.getPropertyValue
    )(request.buildAwsValue())
      .map(zio.aws.iottwinmaker.model.GetPropertyValueResponse.wrap)
      .provideEnvironment(r)
  }
  def createComponentType(
      request: zio.aws.iottwinmaker.model.CreateComponentTypeRequest
  ): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.CreateComponentTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createComponentType(request))
  def listEntities(
      request: zio.aws.iottwinmaker.model.ListEntitiesRequest
  ): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.ListEntitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEntities(request))
  def deleteEntity(
      request: zio.aws.iottwinmaker.model.DeleteEntityRequest
  ): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.DeleteEntityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEntity(request))
  def createWorkspace(
      request: zio.aws.iottwinmaker.model.CreateWorkspaceRequest
  ): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.CreateWorkspaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorkspace(request))
  def deleteScene(request: zio.aws.iottwinmaker.model.DeleteSceneRequest): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.DeleteSceneResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteScene(request))
  def listComponentTypes(
      request: zio.aws.iottwinmaker.model.ListComponentTypesRequest
  ): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.ListComponentTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listComponentTypes(request))
  def listWorkspaces(
      request: zio.aws.iottwinmaker.model.ListWorkspacesRequest
  ): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.ListWorkspacesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkspaces(request))
  def getComponentType(
      request: zio.aws.iottwinmaker.model.GetComponentTypeRequest
  ): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.GetComponentTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getComponentType(request))
  def deleteComponentType(
      request: zio.aws.iottwinmaker.model.DeleteComponentTypeRequest
  ): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.DeleteComponentTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteComponentType(request))
  def createScene(request: zio.aws.iottwinmaker.model.CreateSceneRequest): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.CreateSceneResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createScene(request))
  def getScene(request: zio.aws.iottwinmaker.model.GetSceneRequest): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.GetSceneResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getScene(request))
  def updateScene(request: zio.aws.iottwinmaker.model.UpdateSceneRequest): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.UpdateSceneResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateScene(request))
  def untagResource(
      request: zio.aws.iottwinmaker.model.UntagResourceRequest
  ): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def getEntity(request: zio.aws.iottwinmaker.model.GetEntityRequest): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.GetEntityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEntity(request))
  def updateEntity(
      request: zio.aws.iottwinmaker.model.UpdateEntityRequest
  ): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.UpdateEntityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEntity(request))
  def createEntity(
      request: zio.aws.iottwinmaker.model.CreateEntityRequest
  ): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.CreateEntityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEntity(request))
  def listTagsForResource(
      request: zio.aws.iottwinmaker.model.ListTagsForResourceRequest
  ): ZIO[zio.aws.iottwinmaker.IoTTwinMaker, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: zio.aws.iottwinmaker.model.TagResourceRequest): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def batchPutPropertyValues(
      request: zio.aws.iottwinmaker.model.BatchPutPropertyValuesRequest
  ): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.BatchPutPropertyValuesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchPutPropertyValues(request))
  def deleteWorkspace(
      request: zio.aws.iottwinmaker.model.DeleteWorkspaceRequest
  ): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.DeleteWorkspaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWorkspace(request))
  def updateComponentType(
      request: zio.aws.iottwinmaker.model.UpdateComponentTypeRequest
  ): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.UpdateComponentTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateComponentType(request))
  def getPropertyValueHistory(
      request: zio.aws.iottwinmaker.model.GetPropertyValueHistoryRequest
  ): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.GetPropertyValueHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPropertyValueHistory(request))
  def getWorkspace(
      request: zio.aws.iottwinmaker.model.GetWorkspaceRequest
  ): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.GetWorkspaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWorkspace(request))
  def listScenes(request: zio.aws.iottwinmaker.model.ListScenesRequest): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.ListScenesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listScenes(request))
  def updateWorkspace(
      request: zio.aws.iottwinmaker.model.UpdateWorkspaceRequest
  ): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.UpdateWorkspaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWorkspace(request))
  def getPropertyValue(
      request: zio.aws.iottwinmaker.model.GetPropertyValueRequest
  ): ZIO[
    zio.aws.iottwinmaker.IoTTwinMaker,
    AwsError,
    zio.aws.iottwinmaker.model.GetPropertyValueResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPropertyValue(request))
}
