package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{EntityId, Name}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EntityPropertyReference(
    componentName: Optional[Name] = Optional.Absent,
    entityId: Optional[EntityId] = Optional.Absent,
    externalIdProperty: Optional[Map[String, String]] = Optional.Absent,
    propertyName: Name
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.EntityPropertyReference = {
    import EntityPropertyReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.EntityPropertyReference
      .builder()
      .optionallyWith(
        componentName.map(value => Name.unwrap(value): java.lang.String)
      )(_.componentName)
      .optionallyWith(
        entityId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.entityId)
      .optionallyWith(
        externalIdProperty.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.externalIdProperty)
      .propertyName(Name.unwrap(propertyName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.EntityPropertyReference.ReadOnly =
    zio.aws.iottwinmaker.model.EntityPropertyReference.wrap(buildAwsValue())
}
object EntityPropertyReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.EntityPropertyReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.EntityPropertyReference =
      zio.aws.iottwinmaker.model.EntityPropertyReference(
        componentName.map(value => value),
        entityId.map(value => value),
        externalIdProperty.map(value => value),
        propertyName
      )
    def componentName: Optional[Name]
    def entityId: Optional[EntityId]
    def externalIdProperty: Optional[Map[String, String]]
    def propertyName: Name
    def getComponentName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("componentName", componentName)
    def getEntityId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("entityId", entityId)
    def getExternalIdProperty: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("externalIdProperty", externalIdProperty)
    def getPropertyName: ZIO[Any, Nothing, Name] = ZIO.succeed(propertyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.EntityPropertyReference
  ) extends zio.aws.iottwinmaker.model.EntityPropertyReference.ReadOnly {
    override val componentName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.componentName())
      .map(value => zio.aws.iottwinmaker.model.primitives.Name(value))
    override val entityId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.entityId())
      .map(value => zio.aws.iottwinmaker.model.primitives.EntityId(value))
    override val externalIdProperty: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalIdProperty())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val propertyName: Name =
      zio.aws.iottwinmaker.model.primitives.Name(impl.propertyName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.EntityPropertyReference
  ): zio.aws.iottwinmaker.model.EntityPropertyReference.ReadOnly = new Wrapper(
    impl
  )
}
