package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.Name
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetPropertyValueResponse(
    propertyValues: Map[Name, zio.aws.iottwinmaker.model.PropertyLatestValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse = {
    import GetPropertyValueResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse
      .builder()
      .propertyValues(
        propertyValues
          .map({ case (key, value) =>
            (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetPropertyValueResponse.ReadOnly =
    zio.aws.iottwinmaker.model.GetPropertyValueResponse.wrap(buildAwsValue())
}
object GetPropertyValueResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetPropertyValueResponse =
      zio.aws.iottwinmaker.model.GetPropertyValueResponse(propertyValues.map({
        case (key, value) =>
          key -> value.asEditable
      }))
    def propertyValues
        : Map[Name, zio.aws.iottwinmaker.model.PropertyLatestValue.ReadOnly]
    def getPropertyValues: ZIO[Any, Nothing, Map[
      Name,
      zio.aws.iottwinmaker.model.PropertyLatestValue.ReadOnly
    ]] = ZIO.succeed(propertyValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse
  ) extends zio.aws.iottwinmaker.model.GetPropertyValueResponse.ReadOnly {
    override val propertyValues
        : Map[Name, zio.aws.iottwinmaker.model.PropertyLatestValue.ReadOnly] =
      impl
        .propertyValues()
        .asScala
        .map({ case (key, value) =>
          zio.aws.iottwinmaker.model.primitives.Name(
            key
          ) -> zio.aws.iottwinmaker.model.PropertyLatestValue.wrap(value)
        })
        .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse
  ): zio.aws.iottwinmaker.model.GetPropertyValueResponse.ReadOnly = new Wrapper(
    impl
  )
}
