package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{Value, Name}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PropertyDefinitionResponse(
    configuration: Optional[Map[Name, Value]] = Optional.Absent,
    dataType: zio.aws.iottwinmaker.model.DataType,
    defaultValue: Optional[zio.aws.iottwinmaker.model.DataValue] =
      Optional.Absent,
    isExternalId: Boolean,
    isFinal: Boolean,
    isImported: Boolean,
    isInherited: Boolean,
    isRequiredInEntity: Boolean,
    isStoredExternally: Boolean,
    isTimeSeries: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionResponse = {
    import PropertyDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionResponse
      .builder()
      .optionallyWith(
        configuration.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> (Value.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.configuration)
      .dataType(dataType.buildAwsValue())
      .optionallyWith(defaultValue.map(value => value.buildAwsValue()))(
        _.defaultValue
      )
      .isExternalId(isExternalId: java.lang.Boolean)
      .isFinal(isFinal: java.lang.Boolean)
      .isImported(isImported: java.lang.Boolean)
      .isInherited(isInherited: java.lang.Boolean)
      .isRequiredInEntity(isRequiredInEntity: java.lang.Boolean)
      .isStoredExternally(isStoredExternally: java.lang.Boolean)
      .isTimeSeries(isTimeSeries: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.PropertyDefinitionResponse.ReadOnly =
    zio.aws.iottwinmaker.model.PropertyDefinitionResponse.wrap(buildAwsValue())
}
object PropertyDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.PropertyDefinitionResponse =
      zio.aws.iottwinmaker.model.PropertyDefinitionResponse(
        configuration.map(value => value),
        dataType.asEditable,
        defaultValue.map(value => value.asEditable),
        isExternalId,
        isFinal,
        isImported,
        isInherited,
        isRequiredInEntity,
        isStoredExternally,
        isTimeSeries
      )
    def configuration: Optional[Map[Name, Value]]
    def dataType: zio.aws.iottwinmaker.model.DataType.ReadOnly
    def defaultValue: Optional[zio.aws.iottwinmaker.model.DataValue.ReadOnly]
    def isExternalId: Boolean
    def isFinal: Boolean
    def isImported: Boolean
    def isInherited: Boolean
    def isRequiredInEntity: Boolean
    def isStoredExternally: Boolean
    def isTimeSeries: Boolean
    def getConfiguration: ZIO[Any, AwsError, Map[Name, Value]] =
      AwsError.unwrapOptionField("configuration", configuration)
    def getDataType
        : ZIO[Any, Nothing, zio.aws.iottwinmaker.model.DataType.ReadOnly] =
      ZIO.succeed(dataType)
    def getDefaultValue
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.DataValue.ReadOnly] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getIsExternalId: ZIO[Any, Nothing, Boolean] = ZIO.succeed(isExternalId)
    def getIsFinal: ZIO[Any, Nothing, Boolean] = ZIO.succeed(isFinal)
    def getIsImported: ZIO[Any, Nothing, Boolean] = ZIO.succeed(isImported)
    def getIsInherited: ZIO[Any, Nothing, Boolean] = ZIO.succeed(isInherited)
    def getIsRequiredInEntity: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(isRequiredInEntity)
    def getIsStoredExternally: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(isStoredExternally)
    def getIsTimeSeries: ZIO[Any, Nothing, Boolean] = ZIO.succeed(isTimeSeries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionResponse
  ) extends zio.aws.iottwinmaker.model.PropertyDefinitionResponse.ReadOnly {
    override val configuration: Optional[Map[Name, Value]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iottwinmaker.model.primitives
                .Name(key) -> zio.aws.iottwinmaker.model.primitives.Value(value)
            })
            .toMap
        )
    override val dataType: zio.aws.iottwinmaker.model.DataType.ReadOnly =
      zio.aws.iottwinmaker.model.DataType.wrap(impl.dataType())
    override val defaultValue
        : Optional[zio.aws.iottwinmaker.model.DataValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultValue())
        .map(value => zio.aws.iottwinmaker.model.DataValue.wrap(value))
    override val isExternalId: Boolean = impl.isExternalId(): Boolean
    override val isFinal: Boolean = impl.isFinal(): Boolean
    override val isImported: Boolean = impl.isImported(): Boolean
    override val isInherited: Boolean = impl.isInherited(): Boolean
    override val isRequiredInEntity: Boolean =
      impl.isRequiredInEntity(): Boolean
    override val isStoredExternally: Boolean =
      impl.isStoredExternally(): Boolean
    override val isTimeSeries: Boolean = impl.isTimeSeries(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionResponse
  ): zio.aws.iottwinmaker.model.PropertyDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
