package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{Value, Name}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PropertyDefinitionRequest(
    configuration: Optional[Map[Name, Value]] = Optional.Absent,
    dataType: Optional[zio.aws.iottwinmaker.model.DataType] = Optional.Absent,
    defaultValue: Optional[zio.aws.iottwinmaker.model.DataValue] =
      Optional.Absent,
    isExternalId: Optional[Boolean] = Optional.Absent,
    isRequiredInEntity: Optional[Boolean] = Optional.Absent,
    isStoredExternally: Optional[Boolean] = Optional.Absent,
    isTimeSeries: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionRequest = {
    import PropertyDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionRequest
      .builder()
      .optionallyWith(
        configuration.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> (Value.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.configuration)
      .optionallyWith(dataType.map(value => value.buildAwsValue()))(_.dataType)
      .optionallyWith(defaultValue.map(value => value.buildAwsValue()))(
        _.defaultValue
      )
      .optionallyWith(isExternalId.map(value => value: java.lang.Boolean))(
        _.isExternalId
      )
      .optionallyWith(
        isRequiredInEntity.map(value => value: java.lang.Boolean)
      )(_.isRequiredInEntity)
      .optionallyWith(
        isStoredExternally.map(value => value: java.lang.Boolean)
      )(_.isStoredExternally)
      .optionallyWith(isTimeSeries.map(value => value: java.lang.Boolean))(
        _.isTimeSeries
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.PropertyDefinitionRequest.ReadOnly =
    zio.aws.iottwinmaker.model.PropertyDefinitionRequest.wrap(buildAwsValue())
}
object PropertyDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.PropertyDefinitionRequest =
      zio.aws.iottwinmaker.model.PropertyDefinitionRequest(
        configuration.map(value => value),
        dataType.map(value => value.asEditable),
        defaultValue.map(value => value.asEditable),
        isExternalId.map(value => value),
        isRequiredInEntity.map(value => value),
        isStoredExternally.map(value => value),
        isTimeSeries.map(value => value)
      )
    def configuration: Optional[Map[Name, Value]]
    def dataType: Optional[zio.aws.iottwinmaker.model.DataType.ReadOnly]
    def defaultValue: Optional[zio.aws.iottwinmaker.model.DataValue.ReadOnly]
    def isExternalId: Optional[Boolean]
    def isRequiredInEntity: Optional[Boolean]
    def isStoredExternally: Optional[Boolean]
    def isTimeSeries: Optional[Boolean]
    def getConfiguration: ZIO[Any, AwsError, Map[Name, Value]] =
      AwsError.unwrapOptionField("configuration", configuration)
    def getDataType
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.DataType.ReadOnly] =
      AwsError.unwrapOptionField("dataType", dataType)
    def getDefaultValue
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.DataValue.ReadOnly] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getIsExternalId: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isExternalId", isExternalId)
    def getIsRequiredInEntity: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isRequiredInEntity", isRequiredInEntity)
    def getIsStoredExternally: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isStoredExternally", isStoredExternally)
    def getIsTimeSeries: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isTimeSeries", isTimeSeries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionRequest
  ) extends zio.aws.iottwinmaker.model.PropertyDefinitionRequest.ReadOnly {
    override val configuration: Optional[Map[Name, Value]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configuration())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iottwinmaker.model.primitives
                .Name(key) -> zio.aws.iottwinmaker.model.primitives.Value(value)
            })
            .toMap
        )
    override val dataType
        : Optional[zio.aws.iottwinmaker.model.DataType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataType())
        .map(value => zio.aws.iottwinmaker.model.DataType.wrap(value))
    override val defaultValue
        : Optional[zio.aws.iottwinmaker.model.DataValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultValue())
        .map(value => zio.aws.iottwinmaker.model.DataValue.wrap(value))
    override val isExternalId: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isExternalId())
      .map(value => value: Boolean)
    override val isRequiredInEntity: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isRequiredInEntity())
      .map(value => value: Boolean)
    override val isStoredExternally: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isStoredExternally())
      .map(value => value: Boolean)
    override val isTimeSeries: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isTimeSeries())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionRequest
  ): zio.aws.iottwinmaker.model.PropertyDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
