package zio.aws.iottwinmaker.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{
  TwinMakerArn,
  Timestamp,
  S3Url,
  Description,
  Id
}
import scala.jdk.CollectionConverters._
final case class SceneSummary(
    arn: TwinMakerArn,
    contentLocation: S3Url,
    creationDateTime: Timestamp,
    description: Optional[Description] = Optional.Absent,
    sceneId: Id,
    updateDateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.SceneSummary = {
    import SceneSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.SceneSummary
      .builder()
      .arn(TwinMakerArn.unwrap(arn): java.lang.String)
      .contentLocation(S3Url.unwrap(contentLocation): java.lang.String)
      .creationDateTime(Timestamp.unwrap(creationDateTime): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .sceneId(Id.unwrap(sceneId): java.lang.String)
      .updateDateTime(Timestamp.unwrap(updateDateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.SceneSummary.ReadOnly =
    zio.aws.iottwinmaker.model.SceneSummary.wrap(buildAwsValue())
}
object SceneSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.SceneSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.SceneSummary =
      zio.aws.iottwinmaker.model.SceneSummary(
        arn,
        contentLocation,
        creationDateTime,
        description.map(value => value),
        sceneId,
        updateDateTime
      )
    def arn: TwinMakerArn
    def contentLocation: S3Url
    def creationDateTime: Timestamp
    def description: Optional[Description]
    def sceneId: Id
    def updateDateTime: Timestamp
    def getArn: ZIO[Any, Nothing, TwinMakerArn] = ZIO.succeed(arn)
    def getContentLocation: ZIO[Any, Nothing, S3Url] =
      ZIO.succeed(contentLocation)
    def getCreationDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDateTime)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSceneId: ZIO[Any, Nothing, Id] = ZIO.succeed(sceneId)
    def getUpdateDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(updateDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.SceneSummary
  ) extends zio.aws.iottwinmaker.model.SceneSummary.ReadOnly {
    override val arn: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.arn())
    override val contentLocation: S3Url =
      zio.aws.iottwinmaker.model.primitives.S3Url(impl.contentLocation())
    override val creationDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.creationDateTime())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val sceneId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.sceneId())
    override val updateDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.updateDateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.SceneSummary
  ): zio.aws.iottwinmaker.model.SceneSummary.ReadOnly = new Wrapper(impl)
}
