package zio.aws.iottwinmaker.model
import scala.jdk.CollectionConverters._
sealed trait ErrorCode {
  def unwrap: software.amazon.awssdk.services.iottwinmaker.model.ErrorCode
}
object ErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.iottwinmaker.model.ErrorCode
  ): zio.aws.iottwinmaker.model.ErrorCode = value match {
    case software.amazon.awssdk.services.iottwinmaker.model.ErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iottwinmaker.model.ErrorCode.VALIDATION_ERROR =>
      val r = VALIDATION_ERROR
      r
    case software.amazon.awssdk.services.iottwinmaker.model.ErrorCode.INTERNAL_FAILURE =>
      val r = INTERNAL_FAILURE
      r
  }
  case object unknownToSdkVersion extends zio.aws.iottwinmaker.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.ErrorCode =
      software.amazon.awssdk.services.iottwinmaker.model.ErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object VALIDATION_ERROR extends zio.aws.iottwinmaker.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.ErrorCode =
      software.amazon.awssdk.services.iottwinmaker.model.ErrorCode.VALIDATION_ERROR
  }
  case object INTERNAL_FAILURE extends zio.aws.iottwinmaker.model.ErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.ErrorCode =
      software.amazon.awssdk.services.iottwinmaker.model.ErrorCode.INTERNAL_FAILURE
  }
}
