package zio.aws.iottwinmaker.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{
  TwinMakerArn,
  NextToken,
  MaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    resourceARN: TwinMakerArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ListTagsForResourceRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .resourceARN(TwinMakerArn.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.iottwinmaker.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ListTagsForResourceRequest =
      zio.aws.iottwinmaker.model.ListTagsForResourceRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        resourceARN
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def resourceARN: TwinMakerArn
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResourceARN: ZIO[Any, Nothing, TwinMakerArn] =
      ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListTagsForResourceRequest
  ) extends zio.aws.iottwinmaker.model.ListTagsForResourceRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iottwinmaker.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
    override val resourceARN: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListTagsForResourceRequest
  ): zio.aws.iottwinmaker.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
