package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.IdOrArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetWorkspaceRequest(workspaceId: IdOrArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceRequest = {
    import GetWorkspaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceRequest
      .builder()
      .workspaceId(IdOrArn.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetWorkspaceRequest.ReadOnly =
    zio.aws.iottwinmaker.model.GetWorkspaceRequest.wrap(buildAwsValue())
}
object GetWorkspaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetWorkspaceRequest =
      zio.aws.iottwinmaker.model.GetWorkspaceRequest(workspaceId)
    def workspaceId: IdOrArn
    def getWorkspaceId: ZIO[Any, Nothing, IdOrArn] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceRequest
  ) extends zio.aws.iottwinmaker.model.GetWorkspaceRequest.ReadOnly {
    override val workspaceId: IdOrArn =
      zio.aws.iottwinmaker.model.primitives.IdOrArn(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceRequest
  ): zio.aws.iottwinmaker.model.GetWorkspaceRequest.ReadOnly = new Wrapper(impl)
}
