package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{Id, EntityId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetEntityRequest(entityId: EntityId, workspaceId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetEntityRequest = {
    import GetEntityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetEntityRequest
      .builder()
      .entityId(EntityId.unwrap(entityId): java.lang.String)
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetEntityRequest.ReadOnly =
    zio.aws.iottwinmaker.model.GetEntityRequest.wrap(buildAwsValue())
}
object GetEntityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetEntityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetEntityRequest =
      zio.aws.iottwinmaker.model.GetEntityRequest(entityId, workspaceId)
    def entityId: EntityId
    def workspaceId: Id
    def getEntityId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(entityId)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetEntityRequest
  ) extends zio.aws.iottwinmaker.model.GetEntityRequest.ReadOnly {
    override val entityId: EntityId =
      zio.aws.iottwinmaker.model.primitives.EntityId(impl.entityId())
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetEntityRequest
  ): zio.aws.iottwinmaker.model.GetEntityRequest.ReadOnly = new Wrapper(impl)
}
