package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{Id, ComponentTypeId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetComponentTypeRequest(
    componentTypeId: ComponentTypeId,
    workspaceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeRequest = {
    import GetComponentTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeRequest
      .builder()
      .componentTypeId(
        ComponentTypeId.unwrap(componentTypeId): java.lang.String
      )
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetComponentTypeRequest.ReadOnly =
    zio.aws.iottwinmaker.model.GetComponentTypeRequest.wrap(buildAwsValue())
}
object GetComponentTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetComponentTypeRequest =
      zio.aws.iottwinmaker.model
        .GetComponentTypeRequest(componentTypeId, workspaceId)
    def componentTypeId: ComponentTypeId
    def workspaceId: Id
    def getComponentTypeId: ZIO[Any, Nothing, ComponentTypeId] =
      ZIO.succeed(componentTypeId)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeRequest
  ) extends zio.aws.iottwinmaker.model.GetComponentTypeRequest.ReadOnly {
    override val componentTypeId: ComponentTypeId =
      zio.aws.iottwinmaker.model.primitives
        .ComponentTypeId(impl.componentTypeId())
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeRequest
  ): zio.aws.iottwinmaker.model.GetComponentTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
