package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.ErrorMessage
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ErrorDetails(
    code: Optional[zio.aws.iottwinmaker.model.ErrorCode] = Optional.Absent,
    message: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ErrorDetails = {
    import ErrorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ErrorDetails
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ErrorDetails.ReadOnly =
    zio.aws.iottwinmaker.model.ErrorDetails.wrap(buildAwsValue())
}
object ErrorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ErrorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ErrorDetails =
      zio.aws.iottwinmaker.model
        .ErrorDetails(code.map(value => value), message.map(value => value))
    def code: Optional[zio.aws.iottwinmaker.model.ErrorCode]
    def message: Optional[ErrorMessage]
    def getCode: ZIO[Any, AwsError, zio.aws.iottwinmaker.model.ErrorCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ErrorDetails
  ) extends zio.aws.iottwinmaker.model.ErrorDetails.ReadOnly {
    override val code: Optional[zio.aws.iottwinmaker.model.ErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value => zio.aws.iottwinmaker.model.ErrorCode.wrap(value))
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.iottwinmaker.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ErrorDetails
  ): zio.aws.iottwinmaker.model.ErrorDetails.ReadOnly = new Wrapper(impl)
}
