package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{EntityId, Name}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RelationshipValue(
    targetComponentName: Option[Name] = None,
    targetEntityId: Option[EntityId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.RelationshipValue = {
    import RelationshipValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.RelationshipValue
      .builder()
      .optionallyWith(
        targetComponentName.map(value => Name.unwrap(value): java.lang.String)
      )(_.targetComponentName)
      .optionallyWith(
        targetEntityId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.targetEntityId)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.RelationshipValue.ReadOnly =
    zio.aws.iottwinmaker.model.RelationshipValue.wrap(buildAwsValue())
}
object RelationshipValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.RelationshipValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.RelationshipValue =
      zio.aws.iottwinmaker.model.RelationshipValue(
        targetComponentName.map(value => value),
        targetEntityId.map(value => value)
      )
    def targetComponentName: Option[Name]
    def targetEntityId: Option[EntityId]
    def getTargetComponentName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("targetComponentName", targetComponentName)
    def getTargetEntityId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("targetEntityId", targetEntityId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.RelationshipValue
  ) extends zio.aws.iottwinmaker.model.RelationshipValue.ReadOnly {
    override val targetComponentName: Option[Name] = scala
      .Option(impl.targetComponentName())
      .map(value => zio.aws.iottwinmaker.model.primitives.Name(value))
    override val targetEntityId: Option[EntityId] = scala
      .Option(impl.targetEntityId())
      .map(value => zio.aws.iottwinmaker.model.primitives.EntityId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.RelationshipValue
  ): zio.aws.iottwinmaker.model.RelationshipValue.ReadOnly = new Wrapper(impl)
}
