package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{ParentEntityId, ComponentTypeId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListEntitiesFilter(
    componentTypeId: Option[ComponentTypeId] = None,
    parentEntityId: Option[ParentEntityId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesFilter = {
    import ListEntitiesFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesFilter
      .builder()
      .optionallyWith(
        componentTypeId.map(value =>
          ComponentTypeId.unwrap(value): java.lang.String
        )
      )(_.componentTypeId)
      .optionallyWith(
        parentEntityId.map(value =>
          ParentEntityId.unwrap(value): java.lang.String
        )
      )(_.parentEntityId)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ListEntitiesFilter.ReadOnly =
    zio.aws.iottwinmaker.model.ListEntitiesFilter.wrap(buildAwsValue())
}
object ListEntitiesFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ListEntitiesFilter =
      zio.aws.iottwinmaker.model.ListEntitiesFilter(
        componentTypeId.map(value => value),
        parentEntityId.map(value => value)
      )
    def componentTypeId: Option[ComponentTypeId]
    def parentEntityId: Option[ParentEntityId]
    def getComponentTypeId: ZIO[Any, AwsError, ComponentTypeId] =
      AwsError.unwrapOptionField("componentTypeId", componentTypeId)
    def getParentEntityId: ZIO[Any, AwsError, ParentEntityId] =
      AwsError.unwrapOptionField("parentEntityId", parentEntityId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesFilter
  ) extends zio.aws.iottwinmaker.model.ListEntitiesFilter.ReadOnly {
    override val componentTypeId: Option[ComponentTypeId] = scala
      .Option(impl.componentTypeId())
      .map(value =>
        zio.aws.iottwinmaker.model.primitives.ComponentTypeId(value)
      )
    override val parentEntityId: Option[ParentEntityId] = scala
      .Option(impl.parentEntityId())
      .map(value => zio.aws.iottwinmaker.model.primitives.ParentEntityId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesFilter
  ): zio.aws.iottwinmaker.model.ListEntitiesFilter.ReadOnly = new Wrapper(impl)
}
