package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.ErrorMessage
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ErrorDetails(
    code: Option[zio.aws.iottwinmaker.model.ErrorCode] = None,
    message: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ErrorDetails = {
    import ErrorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ErrorDetails
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ErrorDetails.ReadOnly =
    zio.aws.iottwinmaker.model.ErrorDetails.wrap(buildAwsValue())
}
object ErrorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ErrorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ErrorDetails =
      zio.aws.iottwinmaker.model
        .ErrorDetails(code.map(value => value), message.map(value => value))
    def code: Option[zio.aws.iottwinmaker.model.ErrorCode]
    def message: Option[ErrorMessage]
    def getCode: ZIO[Any, AwsError, zio.aws.iottwinmaker.model.ErrorCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ErrorDetails
  ) extends zio.aws.iottwinmaker.model.ErrorDetails.ReadOnly {
    override val code: Option[zio.aws.iottwinmaker.model.ErrorCode] = scala
      .Option(impl.code())
      .map(value => zio.aws.iottwinmaker.model.ErrorCode.wrap(value))
    override val message: Option[ErrorMessage] = scala
      .Option(impl.message())
      .map(value => zio.aws.iottwinmaker.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ErrorDetails
  ): zio.aws.iottwinmaker.model.ErrorDetails.ReadOnly = new Wrapper(impl)
}
