package zio.aws.iottwinmaker.model
import java.lang.Integer
import zio.aws.iottwinmaker.model.primitives.{
  TwinMakerArn,
  NextToken,
  MaxResults
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    resourceARN: TwinMakerArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ListTagsForResourceRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .resourceARN(TwinMakerArn.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.iottwinmaker.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ListTagsForResourceRequest =
      zio.aws.iottwinmaker.model.ListTagsForResourceRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        resourceARN
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def resourceARN: TwinMakerArn
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResourceARN: ZIO[Any, Nothing, TwinMakerArn] =
      ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListTagsForResourceRequest
  ) extends zio.aws.iottwinmaker.model.ListTagsForResourceRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iottwinmaker.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
    override val resourceARN: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListTagsForResourceRequest
  ): zio.aws.iottwinmaker.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
