package zio.aws.iottwinmaker.model
import java.lang.Integer
import zio.aws.iottwinmaker.model.primitives.{Id, NextToken, MaxResults}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListEntitiesRequest(
    filters: Option[Iterable[zio.aws.iottwinmaker.model.ListEntitiesFilter]] =
      None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    workspaceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest = {
    import ListEntitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ListEntitiesRequest.ReadOnly =
    zio.aws.iottwinmaker.model.ListEntitiesRequest.wrap(buildAwsValue())
}
object ListEntitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ListEntitiesRequest =
      zio.aws.iottwinmaker.model.ListEntitiesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value),
        workspaceId
      )
    def filters
        : Option[List[zio.aws.iottwinmaker.model.ListEntitiesFilter.ReadOnly]]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def workspaceId: Id
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.ListEntitiesFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest
  ) extends zio.aws.iottwinmaker.model.ListEntitiesRequest.ReadOnly {
    override val filters
        : Option[List[zio.aws.iottwinmaker.model.ListEntitiesFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.ListEntitiesFilter.wrap(item)
          }.toList
        )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iottwinmaker.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest
  ): zio.aws.iottwinmaker.model.ListEntitiesRequest.ReadOnly = new Wrapper(impl)
}
