package zio.aws.iottwinmaker.model
import java.lang.Integer
import zio.aws.iottwinmaker.model.primitives.{Id, NextToken, MaxResults}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListComponentTypesRequest(
    filters: Option[
      Iterable[zio.aws.iottwinmaker.model.ListComponentTypesFilter]
    ] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None,
    workspaceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest = {
    import ListComponentTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.ListComponentTypesRequest.ReadOnly =
    zio.aws.iottwinmaker.model.ListComponentTypesRequest.wrap(buildAwsValue())
}
object ListComponentTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ListComponentTypesRequest =
      zio.aws.iottwinmaker.model.ListComponentTypesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value),
        workspaceId
      )
    def filters: Option[
      List[zio.aws.iottwinmaker.model.ListComponentTypesFilter.ReadOnly]
    ]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def workspaceId: Id
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.ListComponentTypesFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest
  ) extends zio.aws.iottwinmaker.model.ListComponentTypesRequest.ReadOnly {
    override val filters: Option[
      List[zio.aws.iottwinmaker.model.ListComponentTypesFilter.ReadOnly]
    ] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iottwinmaker.model.ListComponentTypesFilter.wrap(item)
        }.toList
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iottwinmaker.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest
  ): zio.aws.iottwinmaker.model.ListComponentTypesRequest.ReadOnly =
    new Wrapper(impl)
}
