package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  Id,
  EntityId,
  ComponentTypeId,
  Name
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetPropertyValueRequest(
    componentName: Option[Name] = None,
    componentTypeId: Option[ComponentTypeId] = None,
    entityId: Option[EntityId] = None,
    selectedProperties: Iterable[String],
    workspaceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest = {
    import GetPropertyValueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest
      .builder()
      .optionallyWith(
        componentName.map(value => Name.unwrap(value): java.lang.String)
      )(_.componentName)
      .optionallyWith(
        componentTypeId.map(value =>
          ComponentTypeId.unwrap(value): java.lang.String
        )
      )(_.componentTypeId)
      .optionallyWith(
        entityId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.entityId)
      .selectedProperties(selectedProperties.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetPropertyValueRequest.ReadOnly =
    zio.aws.iottwinmaker.model.GetPropertyValueRequest.wrap(buildAwsValue())
}
object GetPropertyValueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetPropertyValueRequest =
      zio.aws.iottwinmaker.model.GetPropertyValueRequest(
        componentName.map(value => value),
        componentTypeId.map(value => value),
        entityId.map(value => value),
        selectedProperties,
        workspaceId
      )
    def componentName: Option[Name]
    def componentTypeId: Option[ComponentTypeId]
    def entityId: Option[EntityId]
    def selectedProperties: List[String]
    def workspaceId: Id
    def getComponentName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("componentName", componentName)
    def getComponentTypeId: ZIO[Any, AwsError, ComponentTypeId] =
      AwsError.unwrapOptionField("componentTypeId", componentTypeId)
    def getEntityId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("entityId", entityId)
    def getSelectedProperties: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(selectedProperties)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest
  ) extends zio.aws.iottwinmaker.model.GetPropertyValueRequest.ReadOnly {
    override val componentName: Option[Name] = scala
      .Option(impl.componentName())
      .map(value => zio.aws.iottwinmaker.model.primitives.Name(value))
    override val componentTypeId: Option[ComponentTypeId] = scala
      .Option(impl.componentTypeId())
      .map(value =>
        zio.aws.iottwinmaker.model.primitives.ComponentTypeId(value)
      )
    override val entityId: Option[EntityId] = scala
      .Option(impl.entityId())
      .map(value => zio.aws.iottwinmaker.model.primitives.EntityId(value))
    override val selectedProperties: List[String] = impl
      .selectedProperties()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest
  ): zio.aws.iottwinmaker.model.GetPropertyValueRequest.ReadOnly = new Wrapper(
    impl
  )
}
