package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListScenesResponse(
    nextToken: Option[NextToken] = None,
    sceneSummaries: Option[Iterable[zio.aws.iottwinmaker.model.SceneSummary]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse = {
    import ListScenesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        sceneSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sceneSummaries)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ListScenesResponse.ReadOnly =
    zio.aws.iottwinmaker.model.ListScenesResponse.wrap(buildAwsValue())
}
object ListScenesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ListScenesResponse =
      zio.aws.iottwinmaker.model.ListScenesResponse(
        nextToken.map(value => value),
        sceneSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def sceneSummaries
        : Option[List[zio.aws.iottwinmaker.model.SceneSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSceneSummaries: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.SceneSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("sceneSummaries", sceneSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse
  ) extends zio.aws.iottwinmaker.model.ListScenesResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
    override val sceneSummaries
        : Option[List[zio.aws.iottwinmaker.model.SceneSummary.ReadOnly]] = scala
      .Option(impl.sceneSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iottwinmaker.model.SceneSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse
  ): zio.aws.iottwinmaker.model.ListScenesResponse.ReadOnly = new Wrapper(impl)
}
