package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.Name
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FunctionResponse(
    implementedBy: Option[zio.aws.iottwinmaker.model.DataConnector] = None,
    isInherited: Option[Boolean] = None,
    requiredProperties: Option[Iterable[Name]] = None,
    scope: Option[zio.aws.iottwinmaker.model.Scope] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.FunctionResponse = {
    import FunctionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.FunctionResponse
      .builder()
      .optionallyWith(implementedBy.map(value => value.buildAwsValue()))(
        _.implementedBy
      )
      .optionallyWith(isInherited.map(value => value: java.lang.Boolean))(
        _.isInherited
      )
      .optionallyWith(
        requiredProperties.map(value =>
          value.map { item =>
            Name.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.requiredProperties)
      .optionallyWith(scope.map(value => value.unwrap))(_.scope)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.FunctionResponse.ReadOnly =
    zio.aws.iottwinmaker.model.FunctionResponse.wrap(buildAwsValue())
}
object FunctionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.FunctionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.FunctionResponse =
      zio.aws.iottwinmaker.model.FunctionResponse(
        implementedBy.map(value => value.asEditable),
        isInherited.map(value => value),
        requiredProperties.map(value => value),
        scope.map(value => value)
      )
    def implementedBy: Option[zio.aws.iottwinmaker.model.DataConnector.ReadOnly]
    def isInherited: Option[Boolean]
    def requiredProperties: Option[List[Name]]
    def scope: Option[zio.aws.iottwinmaker.model.Scope]
    def getImplementedBy: ZIO[
      Any,
      AwsError,
      zio.aws.iottwinmaker.model.DataConnector.ReadOnly
    ] = AwsError.unwrapOptionField("implementedBy", implementedBy)
    def getIsInherited: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isInherited", isInherited)
    def getRequiredProperties: ZIO[Any, AwsError, List[Name]] =
      AwsError.unwrapOptionField("requiredProperties", requiredProperties)
    def getScope: ZIO[Any, AwsError, zio.aws.iottwinmaker.model.Scope] =
      AwsError.unwrapOptionField("scope", scope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.FunctionResponse
  ) extends zio.aws.iottwinmaker.model.FunctionResponse.ReadOnly {
    override val implementedBy
        : Option[zio.aws.iottwinmaker.model.DataConnector.ReadOnly] = scala
      .Option(impl.implementedBy())
      .map(value => zio.aws.iottwinmaker.model.DataConnector.wrap(value))
    override val isInherited: Option[Boolean] =
      scala.Option(impl.isInherited()).map(value => value: Boolean)
    override val requiredProperties: Option[List[Name]] = scala
      .Option(impl.requiredProperties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iottwinmaker.model.primitives.Name(item)
        }.toList
      )
    override val scope: Option[zio.aws.iottwinmaker.model.Scope] = scala
      .Option(impl.scope())
      .map(value => zio.aws.iottwinmaker.model.Scope.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.FunctionResponse
  ): zio.aws.iottwinmaker.model.FunctionResponse.ReadOnly = new Wrapper(impl)
}
