package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  Name,
  Description,
  ComponentTypeId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ComponentRequest(
    componentTypeId: Option[ComponentTypeId] = None,
    description: Option[Description] = None,
    properties: Option[Map[Name, zio.aws.iottwinmaker.model.PropertyRequest]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ComponentRequest = {
    import ComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ComponentRequest
      .builder()
      .optionallyWith(
        componentTypeId.map(value =>
          ComponentTypeId.unwrap(value): java.lang.String
        )
      )(_.componentTypeId)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        properties.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.properties)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ComponentRequest.ReadOnly =
    zio.aws.iottwinmaker.model.ComponentRequest.wrap(buildAwsValue())
}
object ComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ComponentRequest =
      zio.aws.iottwinmaker.model.ComponentRequest(
        componentTypeId.map(value => value),
        description.map(value => value),
        properties.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def componentTypeId: Option[ComponentTypeId]
    def description: Option[Description]
    def properties
        : Option[Map[Name, zio.aws.iottwinmaker.model.PropertyRequest.ReadOnly]]
    def getComponentTypeId: ZIO[Any, AwsError, ComponentTypeId] =
      AwsError.unwrapOptionField("componentTypeId", componentTypeId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getProperties: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.PropertyRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("properties", properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ComponentRequest
  ) extends zio.aws.iottwinmaker.model.ComponentRequest.ReadOnly {
    override val componentTypeId: Option[ComponentTypeId] = scala
      .Option(impl.componentTypeId())
      .map(value =>
        zio.aws.iottwinmaker.model.primitives.ComponentTypeId(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val properties: Option[
      Map[Name, zio.aws.iottwinmaker.model.PropertyRequest.ReadOnly]
    ] = scala
      .Option(impl.properties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.PropertyRequest.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ComponentRequest
  ): zio.aws.iottwinmaker.model.ComponentRequest.ReadOnly = new Wrapper(impl)
}
