package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  SceneCapability,
  TagValue,
  S3Url,
  Description,
  Id,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateSceneRequest(
    capabilities: Option[Iterable[SceneCapability]] = None,
    contentLocation: S3Url,
    description: Option[Description] = None,
    sceneId: Id,
    tags: Option[Map[TagKey, TagValue]] = None,
    workspaceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.CreateSceneRequest = {
    import CreateSceneRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.CreateSceneRequest
      .builder()
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            SceneCapability.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.capabilities)
      .contentLocation(S3Url.unwrap(contentLocation): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .sceneId(Id.unwrap(sceneId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.CreateSceneRequest.ReadOnly =
    zio.aws.iottwinmaker.model.CreateSceneRequest.wrap(buildAwsValue())
}
object CreateSceneRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.CreateSceneRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.CreateSceneRequest =
      zio.aws.iottwinmaker.model.CreateSceneRequest(
        capabilities.map(value => value),
        contentLocation,
        description.map(value => value),
        sceneId,
        tags.map(value => value),
        workspaceId
      )
    def capabilities: Option[List[SceneCapability]]
    def contentLocation: S3Url
    def description: Option[Description]
    def sceneId: Id
    def tags: Option[Map[TagKey, TagValue]]
    def workspaceId: Id
    def getCapabilities: ZIO[Any, AwsError, List[SceneCapability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getContentLocation: ZIO[Any, Nothing, S3Url] =
      ZIO.succeed(contentLocation)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSceneId: ZIO[Any, Nothing, Id] = ZIO.succeed(sceneId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateSceneRequest
  ) extends zio.aws.iottwinmaker.model.CreateSceneRequest.ReadOnly {
    override val capabilities: Option[List[SceneCapability]] = scala
      .Option(impl.capabilities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iottwinmaker.model.primitives.SceneCapability(item)
        }.toList
      )
    override val contentLocation: S3Url =
      zio.aws.iottwinmaker.model.primitives.S3Url(impl.contentLocation())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val sceneId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.sceneId())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.TagKey(
              key
            ) -> zio.aws.iottwinmaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateSceneRequest
  ): zio.aws.iottwinmaker.model.CreateSceneRequest.ReadOnly = new Wrapper(impl)
}
