package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class UpdateWorkspaceResponse(updateDateTime: Timestamp) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.UpdateWorkspaceResponse = {
    import UpdateWorkspaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.UpdateWorkspaceResponse
      .builder()
      .updateDateTime(Timestamp.unwrap(updateDateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.UpdateWorkspaceResponse.ReadOnly =
    zio.aws.iottwinmaker.model.UpdateWorkspaceResponse.wrap(buildAwsValue())
}
object UpdateWorkspaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.UpdateWorkspaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.UpdateWorkspaceResponse =
      zio.aws.iottwinmaker.model.UpdateWorkspaceResponse(updateDateTime)
    def updateDateTime: Timestamp
    def getUpdateDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(updateDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdateWorkspaceResponse
  ) extends zio.aws.iottwinmaker.model.UpdateWorkspaceResponse.ReadOnly {
    override val updateDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.updateDateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdateWorkspaceResponse
  ): zio.aws.iottwinmaker.model.UpdateWorkspaceResponse.ReadOnly = new Wrapper(
    impl
  )
}
