package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteWorkspaceRequest(workspaceId: Id) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.DeleteWorkspaceRequest = {
    import DeleteWorkspaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.DeleteWorkspaceRequest
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.DeleteWorkspaceRequest.ReadOnly =
    zio.aws.iottwinmaker.model.DeleteWorkspaceRequest.wrap(buildAwsValue())
}
object DeleteWorkspaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.DeleteWorkspaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.DeleteWorkspaceRequest =
      zio.aws.iottwinmaker.model.DeleteWorkspaceRequest(workspaceId)
    def workspaceId: Id
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DeleteWorkspaceRequest
  ) extends zio.aws.iottwinmaker.model.DeleteWorkspaceRequest.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DeleteWorkspaceRequest
  ): zio.aws.iottwinmaker.model.DeleteWorkspaceRequest.ReadOnly = new Wrapper(
    impl
  )
}
