package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PropertyLatestValue(
    propertyReference: zio.aws.iottwinmaker.model.EntityPropertyReference,
    propertyValue: Option[zio.aws.iottwinmaker.model.DataValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.PropertyLatestValue = {
    import PropertyLatestValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.PropertyLatestValue
      .builder()
      .propertyReference(propertyReference.buildAwsValue())
      .optionallyWith(propertyValue.map(value => value.buildAwsValue()))(
        _.propertyValue
      )
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.PropertyLatestValue.ReadOnly =
    zio.aws.iottwinmaker.model.PropertyLatestValue.wrap(buildAwsValue())
}
object PropertyLatestValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.PropertyLatestValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.PropertyLatestValue =
      zio.aws.iottwinmaker.model.PropertyLatestValue(
        propertyReference.asEditable,
        propertyValue.map(value => value.asEditable)
      )
    def propertyReference
        : zio.aws.iottwinmaker.model.EntityPropertyReference.ReadOnly
    def propertyValue: Option[zio.aws.iottwinmaker.model.DataValue.ReadOnly]
    def getPropertyReference: ZIO[
      Any,
      Nothing,
      zio.aws.iottwinmaker.model.EntityPropertyReference.ReadOnly
    ] = ZIO.succeed(propertyReference)
    def getPropertyValue
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.DataValue.ReadOnly] =
      AwsError.unwrapOptionField("propertyValue", propertyValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyLatestValue
  ) extends zio.aws.iottwinmaker.model.PropertyLatestValue.ReadOnly {
    override val propertyReference
        : zio.aws.iottwinmaker.model.EntityPropertyReference.ReadOnly =
      zio.aws.iottwinmaker.model.EntityPropertyReference
        .wrap(impl.propertyReference())
    override val propertyValue
        : Option[zio.aws.iottwinmaker.model.DataValue.ReadOnly] = scala
      .Option(impl.propertyValue())
      .map(value => zio.aws.iottwinmaker.model.DataValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyLatestValue
  ): zio.aws.iottwinmaker.model.PropertyLatestValue.ReadOnly = new Wrapper(impl)
}
