package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DataType(
    allowedValues: Option[Iterable[zio.aws.iottwinmaker.model.DataValue]] =
      None,
    nestedType: Option[zio.aws.iottwinmaker.model.DataType] = None,
    relationship: Option[zio.aws.iottwinmaker.model.Relationship] = None,
    `type`: zio.aws.iottwinmaker.model.Type,
    unitOfMeasure: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.DataType = {
    import DataType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.DataType
      .builder()
      .optionallyWith(
        allowedValues.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.allowedValues)
      .optionallyWith(nestedType.map(value => value.buildAwsValue()))(
        _.nestedType
      )
      .optionallyWith(relationship.map(value => value.buildAwsValue()))(
        _.relationship
      )
      .`type`(`type`.unwrap)
      .optionallyWith(unitOfMeasure.map(value => value: java.lang.String))(
        _.unitOfMeasure
      )
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.DataType.ReadOnly =
    zio.aws.iottwinmaker.model.DataType.wrap(buildAwsValue())
}
object DataType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.DataType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.DataType =
      zio.aws.iottwinmaker.model.DataType(
        allowedValues.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nestedType.map(value => value.asEditable),
        relationship.map(value => value.asEditable),
        `type`,
        unitOfMeasure.map(value => value)
      )
    def allowedValues
        : Option[List[zio.aws.iottwinmaker.model.DataValue.ReadOnly]]
    def nestedType: Option[zio.aws.iottwinmaker.model.DataType.ReadOnly]
    def relationship: Option[zio.aws.iottwinmaker.model.Relationship.ReadOnly]
    def `type`: zio.aws.iottwinmaker.model.Type
    def unitOfMeasure: Option[String]
    def getAllowedValues: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.DataValue.ReadOnly
    ]] = AwsError.unwrapOptionField("allowedValues", allowedValues)
    def getNestedType
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.DataType.ReadOnly] =
      AwsError.unwrapOptionField("nestedType", nestedType)
    def getRelationship
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.Relationship.ReadOnly] =
      AwsError.unwrapOptionField("relationship", relationship)
    def getType: ZIO[Any, Nothing, zio.aws.iottwinmaker.model.Type] =
      ZIO.succeed(`type`)
    def getUnitOfMeasure: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("unitOfMeasure", unitOfMeasure)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DataType
  ) extends zio.aws.iottwinmaker.model.DataType.ReadOnly {
    override val allowedValues
        : Option[List[zio.aws.iottwinmaker.model.DataValue.ReadOnly]] = scala
      .Option(impl.allowedValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iottwinmaker.model.DataValue.wrap(item)
        }.toList
      )
    override val nestedType
        : Option[zio.aws.iottwinmaker.model.DataType.ReadOnly] = scala
      .Option(impl.nestedType())
      .map(value => zio.aws.iottwinmaker.model.DataType.wrap(value))
    override val relationship
        : Option[zio.aws.iottwinmaker.model.Relationship.ReadOnly] = scala
      .Option(impl.relationship())
      .map(value => zio.aws.iottwinmaker.model.Relationship.wrap(value))
    override val `type`: zio.aws.iottwinmaker.model.Type =
      zio.aws.iottwinmaker.model.Type.wrap(impl.`type`())
    override val unitOfMeasure: Option[String] =
      scala.Option(impl.unitOfMeasure()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DataType
  ): zio.aws.iottwinmaker.model.DataType.ReadOnly = new Wrapper(impl)
}
