package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.Id
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchPutPropertyValuesRequest(
    entries: Iterable[zio.aws.iottwinmaker.model.PropertyValueEntry],
    workspaceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesRequest = {
    import BatchPutPropertyValuesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesRequest
      .builder()
      .entries(entries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.BatchPutPropertyValuesRequest.ReadOnly =
    zio.aws.iottwinmaker.model.BatchPutPropertyValuesRequest
      .wrap(buildAwsValue())
}
object BatchPutPropertyValuesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.BatchPutPropertyValuesRequest =
      zio.aws.iottwinmaker.model.BatchPutPropertyValuesRequest(
        entries.map { item =>
          item.asEditable
        },
        workspaceId
      )
    def entries: List[zio.aws.iottwinmaker.model.PropertyValueEntry.ReadOnly]
    def workspaceId: Id
    def getEntries: ZIO[Any, Nothing, List[
      zio.aws.iottwinmaker.model.PropertyValueEntry.ReadOnly
    ]] = ZIO.succeed(entries)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesRequest
  ) extends zio.aws.iottwinmaker.model.BatchPutPropertyValuesRequest.ReadOnly {
    override val entries
        : List[zio.aws.iottwinmaker.model.PropertyValueEntry.ReadOnly] = impl
      .entries()
      .asScala
      .map { item =>
        zio.aws.iottwinmaker.model.PropertyValueEntry.wrap(item)
      }
      .toList
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesRequest
  ): zio.aws.iottwinmaker.model.BatchPutPropertyValuesRequest.ReadOnly =
    new Wrapper(impl)
}
