package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  Description,
  EntityId,
  Name,
  EntityName,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateEntityRequest(
    componentUpdates: Option[
      Map[Name, zio.aws.iottwinmaker.model.ComponentUpdateRequest]
    ] = None,
    description: Option[Description] = None,
    entityId: EntityId,
    entityName: Option[EntityName] = None,
    parentEntityUpdate: Option[
      zio.aws.iottwinmaker.model.ParentEntityUpdateRequest
    ] = None,
    workspaceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityRequest = {
    import UpdateEntityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityRequest
      .builder()
      .optionallyWith(
        componentUpdates.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.componentUpdates)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .entityId(EntityId.unwrap(entityId): java.lang.String)
      .optionallyWith(
        entityName.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.entityName)
      .optionallyWith(parentEntityUpdate.map(value => value.buildAwsValue()))(
        _.parentEntityUpdate
      )
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.UpdateEntityRequest.ReadOnly =
    zio.aws.iottwinmaker.model.UpdateEntityRequest.wrap(buildAwsValue())
}
object UpdateEntityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.UpdateEntityRequest =
      zio.aws.iottwinmaker.model.UpdateEntityRequest(
        componentUpdates.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        description.map(value => value),
        entityId,
        entityName.map(value => value),
        parentEntityUpdate.map(value => value.asEditable),
        workspaceId
      )
    def componentUpdates: Option[
      Map[Name, zio.aws.iottwinmaker.model.ComponentUpdateRequest.ReadOnly]
    ]
    def description: Option[Description]
    def entityId: EntityId
    def entityName: Option[EntityName]
    def parentEntityUpdate
        : Option[zio.aws.iottwinmaker.model.ParentEntityUpdateRequest.ReadOnly]
    def workspaceId: Id
    def getComponentUpdates: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.ComponentUpdateRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("componentUpdates", componentUpdates)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEntityId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(entityId)
    def getEntityName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("entityName", entityName)
    def getParentEntityUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.iottwinmaker.model.ParentEntityUpdateRequest.ReadOnly
    ] = AwsError.unwrapOptionField("parentEntityUpdate", parentEntityUpdate)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityRequest
  ) extends zio.aws.iottwinmaker.model.UpdateEntityRequest.ReadOnly {
    override val componentUpdates: Option[
      Map[Name, zio.aws.iottwinmaker.model.ComponentUpdateRequest.ReadOnly]
    ] = scala
      .Option(impl.componentUpdates())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.ComponentUpdateRequest.wrap(value)
          })
          .toMap
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val entityId: EntityId =
      zio.aws.iottwinmaker.model.primitives.EntityId(impl.entityId())
    override val entityName: Option[EntityName] = scala
      .Option(impl.entityName())
      .map(value => zio.aws.iottwinmaker.model.primitives.EntityName(value))
    override val parentEntityUpdate: Option[
      zio.aws.iottwinmaker.model.ParentEntityUpdateRequest.ReadOnly
    ] = scala
      .Option(impl.parentEntityUpdate())
      .map(value =>
        zio.aws.iottwinmaker.model.ParentEntityUpdateRequest.wrap(value)
      )
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityRequest
  ): zio.aws.iottwinmaker.model.UpdateEntityRequest.ReadOnly = new Wrapper(impl)
}
